% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/growthRateMethods.R
\name{sharedMuts}
\alias{sharedMuts}
\title{Growth rate estimate using the sum of shared mutations assuming a mutation tree}
\usage{
sharedMuts(tree, nu = NULL, alpha = 0.05)
}
\arguments{
\item{tree}{A non-ultrametric ape tree subset to include only the clone of interest}

\item{nu}{The mutation rate. If none given, sharedMuts() will first look for a \code{nu} column in a \code{metadata} data.frame of the tree, and then look for a \code{nu} in the tree itself. Will throw error if no \code{nu} given or found.}

\item{alpha}{Used for calculation of confidence intervals. 1-alpha confidence intervals used with default of alpha = 0.05 (95 percent confidence intervals)}
}
\value{
A dataframe including the net growth rate estimate, the sum of internal lengths and other important details (clone age estimate, runtime, n, etc.)
}
\description{
\code{sharedMuts()} provides an estimate for the net growth rate of the clone with confidence bounds, using the shared mutations method.
}
\examples{
sharedMuts(cloneRate::exampleMutTrees[[1]])

}
\seealso{
\code{\link[=internalLengths]{internalLengths()}} which is the ultrametric/time-based analogue
}
