# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Calculate t1 and t2 pairs that have the same p-Value
#'
#' @description
#' Calculates pairs of t1 and t2 values, which have the same p-value for the
#' two-sample equivalency test. See [p_equiv_two_sample()].
#'
#' @param n the size of the qualification sample
#' @param m the size of the equivalency sample
#' @param alpha the desired p-value
#' @param t1max the maximum value of t1 (only approximate)
#' @param t2max the maximum value of t2 (only approximate)
#' @param n_points the number of returned points is twice n_points
#'
#' @details
#' The values t1 and t2 are based on the transformation:
#' 
#' t1 = (X_mean - Y_min) / S
#'
#' t2 = (X_mean - Y_mean) / S
#'
#' Where:
#' - X_mean is the mean of the qualification sample
#' - S is the standard deviation of the qualification sample
#' - Y_min is the minimum from the acceptance sample
#' - Y_mean is the mean of the acceptance sample
#'
#' @return
#' A `data.frame` with values of t1 and t2
#' 
#' @examples
#'\donttest{
#' if(requireNamespace("tidyverse")){
#'   library(cmstatrExt)
#'   library(tidyverse)
#'   curve <- iso_equiv_two_sample(24, 8, 0.05, 4, 1.5, 10)
#'   curve
#' 
#'   curve %>%
#'     ggplot(aes(x = t1, y = t2)) +
#'       geom_path() +
#'       ggtitle("Acceptance criteria for alpha=0.05")
#'}
#'}
#'
#' @seealso
#' [p_equiv_two_sample()], [k_equiv_two_sample()]
#' 
#' @references
#' Kloppenborg, S. (2023). Lot acceptance testing using sample mean and
#' extremum with finite qualification samples. Journal of Quality Technology,
#' https://doi.org/10.1080/00224065.2022.2147884
#'
#' @export
iso_equiv_two_sample <- function(n, m, alpha, t1max, t2max, n_points) {
    .Call(`_cmstatrExt_iso_equiv_two_sample`, n, m, alpha, t1max, t2max, n_points)
}

#' Calculate the factors for a two-sample acceptance test
#'
#' @description
#' Calculates the factors k1 and k2, which are used for setting acceptance
#' values for lot acceptance. These factors consider both the
#' size of the qualification sample (`n`)
#' and the size of acceptance sample (`m`).
#' This test is detailed in a forthcoming paper.
#'
#' @param alpha the desired probability of Type 1 error
#' @param n the size of the qualification sample
#' @param m the size of the acceptance sample
#'
#' @return
#' A vector of length 2 with the contents `c(k1, k2)`
#' 
#' @references
#' Kloppenborg, S. (2023). Lot acceptance testing using sample mean and
#' extremum with finite qualification samples. Journal of Quality Technology,
#' https://doi.org/10.1080/00224065.2022.2147884
#'
#' @export
k_equiv_two_sample <- function(alpha, n, m) {
    .Call(`_cmstatrExt_k_equiv_two_sample`, alpha, n, m)
}

#' p-Value for one-sample equivalency
#'
#' @description
#' Calculates the p-Value for a one-sample acceptance test
#' based on Vangel (2002).
#' This test considers the sample size of the acceptance sample (`m`).
#'
#' Two test statistics are required:
#'
#' t1 = (mu - Y_min) / sigma
#'
#' t2 = (mu - Y_mean) / sigma
#'
#' Where:
#' - mu is the mean of the population
#' - sigma is the standard deviation of the population
#' - Y_min is the minimum from the acceptance sample
#' - Y_mean is the mean of the acceptance sample
#'
#' @param m the size of the acceptance sample
#' @param t1 the test statistic described above. May be a vector.
#' @param t2 the test statistic described above. May be a vector.
#'
#' @return a vector of p-Values of the same length as t1 and t2
#'
#' @export
p_equiv <- function(m, t1, t2) {
    .Call(`_cmstatrExt_p_equiv`, m, t1, t2)
}

#' p-Value for two-sample equivalency
#'
#' @description
#' Calculates the p-Value for a two-sample acceptance test.
#' This test considers the sample size of the qualification
#' sample (`n`) and the acceptance sample (`m`).
#'
#' Two test statistics are required:
#'
#' t1 = (X_mean - Y_min) / S
#'
#' t2 = (X_mean - Y_mean) / S
#'
#' Where:
#' - X_mean is the mean of the qualification sample
#' - S is the standard deviation of the qualification sample
#' - Y_min is the minimum from the acceptance sample
#' - Y_mean is the mean of the acceptance sample
#'
#' @param n the size of the qualification sample
#' @param m the size of the acceptance sample
#' @param t1 the test statistic described above. May be a vector.
#' @param t2 the test statistic described above. May be a vector.
#'
#' @return a vector of p-Values of the same length as t1 and t2
#'
#' @export
p_equiv_two_sample <- function(n, m, t1, t2) {
    .Call(`_cmstatrExt_p_equiv_two_sample`, n, m, t1, t2)
}

power_sim_dual_generic <- function(n_qual, m_equiv, replicates, distribution, dist_function, param_qual, param_equiv, k1, k2) {
    .Call(`_cmstatrExt_power_sim_dual_generic`, n_qual, m_equiv, replicates, distribution, dist_function, param_qual, param_equiv, k1, k2)
}

