% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor_df.R
\name{cor_df}
\alias{cor_df}
\alias{cor_numeric_vs_numeric}
\alias{cor_numeric_vs_categorical}
\alias{cor_categorical_vs_categorical}
\title{Pairwise Correlation Data Frame}
\usage{
cor_df(df = NULL, predictors = NULL, quiet = FALSE)

cor_numeric_vs_numeric(df = NULL, predictors = NULL, quiet = FALSE)

cor_numeric_vs_categorical(df = NULL, predictors = NULL, quiet = FALSE)

cor_categorical_vs_categorical(df = NULL, predictors = NULL, quiet = FALSE)
}
\arguments{
\item{df}{(required; data frame, tibble, or sf) A data frame with responses and predictors. Default: NULL.}

\item{predictors}{(optional; character vector) Names of the predictors to select from \code{df}. If omitted, all numeric columns in \code{df} are used instead. If argument \code{response} is not provided, non-numeric variables are ignored. Default: NULL}

\item{quiet}{(optional; logical) If FALSE, messages generated during the execution of the function are printed to the console Default: FALSE}
}
\value{
data frame; pairwise correlation
}
\description{
Computes a pairwise correlation data frame. Implements methods to compare different types of predictors:
\itemize{
\item \strong{numeric vs. numeric}: as computed with \code{\link[stats:cor]{stats::cor()}} using the methods "pearson" or "spearman", via \code{\link[=cor_numeric_vs_numeric]{cor_numeric_vs_numeric()}}.
\item \strong{numeric vs. categorical}: the function \code{\link[=cor_numeric_vs_categorical]{cor_numeric_vs_categorical()}} target-encodes the categorical variable using the numeric variable as reference with \code{\link[=target_encoding_lab]{target_encoding_lab()}} and the method "loo" (leave-one-out), and then their correlation is computed with \code{\link[stats:cor]{stats::cor()}}.
\item \strong{categorical vs. categorical}: the function \code{\link[=cor_categorical_vs_categorical]{cor_categorical_vs_categorical()}} computes Cramer's V (see \code{\link[=cor_cramer_v]{cor_cramer_v()}}) as indicator of the association between character or factor variables. However, take in mind that Cramer's V is not directly comparable with R-squared, even when having the same range from zero to one. It is always recommended to target-encode categorical variables with \code{\link[=target_encoding_lab]{target_encoding_lab()}} before the pairwise correlation analysis.
}

Accepts a parallelization setup via \code{\link[future:plan]{future::plan()}} and a progress bar via \code{\link[progressr:handlers]{progressr::handlers()}} (see examples).
}
\examples{
data(
  vi,
  vi_predictors
)

#reduce size of vi to speed-up example execution
vi <- vi[1:1000, ]

#mixed predictors
vi_predictors <- vi_predictors[1:10]

#parallelization setup
future::plan(
  future::multisession,
  workers = 2 #set to parallelly::availableCores() - 1
)

#progress bar
# progressr::handlers(global = TRUE)

#correlation data frame
df <- cor_df(
  df = vi,
  predictors = vi_predictors
)

df

#disable parallelization
future::plan(future::sequential)

}
\seealso{
Other pairwise_correlation: 
\code{\link{cor_clusters}()},
\code{\link{cor_cramer_v}()},
\code{\link{cor_matrix}()},
\code{\link{cor_select}()}

Other pairwise_correlation: 
\code{\link{cor_clusters}()},
\code{\link{cor_cramer_v}()},
\code{\link{cor_matrix}()},
\code{\link{cor_select}()}

Other pairwise_correlation: 
\code{\link{cor_clusters}()},
\code{\link{cor_cramer_v}()},
\code{\link{cor_matrix}()},
\code{\link{cor_select}()}

Other pairwise_correlation: 
\code{\link{cor_clusters}()},
\code{\link{cor_cramer_v}()},
\code{\link{cor_matrix}()},
\code{\link{cor_select}()}
}
\concept{pairwise_correlation}
