% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collinear_stats.R
\name{collinear_stats}
\alias{collinear_stats}
\title{Compute summary statistics for correlation and VIF}
\usage{
collinear_stats(df = NULL, predictors = NULL, quiet = FALSE, ...)
}
\arguments{
\item{df}{(required; dataframe, tibble, or sf) A dataframe with predictors or the output of \code{\link[=cor_df]{cor_df()}}. Default: NULL.}

\item{predictors}{(optional; character vector or NULL) Names of the
predictors in \code{df}. If NULL, all columns except \code{responses} and
constant/near-zero-variance columns are used. Default: NULL.}

\item{quiet}{(optional; logical) If FALSE, messages are printed. Default: FALSE.}

\item{...}{(optional) Internal args (e.g. \code{function_name} for
\code{\link{validate_arg_function_name}}, a precomputed correlation matrix
\code{m}, or cross-validation args for \code{\link{preference_order}}).}
}
\value{
dataframe with columns \code{method} (with values "correlation" and "vif"), \code{statistic} and \code{value}
}
\description{
Computes the the minimum, mean, maximum, and quantiles 0.05, 0.25, median (0.5), 0.75, and 0.95 of the correlations and variance inflation factors in a given dataframe. Wraps the functions \code{\link[=cor_stats]{cor_stats()}} and \code{\link[=vif_stats]{vif_stats()}}
}
\examples{
data(
  vi_smol,
  vi_predictors_numeric
  )

## OPTIONAL: parallelization setup
## irrelevant when all predictors are numeric
## only worth it for large data with many categoricals
# future::plan(
#   future::multisession,
#   workers = future::availableCores() - 1
# )

## OPTIONAL: progress bar
# progressr::handlers(global = TRUE)

x <- collinear_stats(
  df = vi_smol,
  predictors = vi_predictors_numeric
)

x

## OPTIONAL: disable parallelization
#future::plan(future::sequential)
}
\seealso{
Other multicollinearity_assessment: 
\code{\link{cor_clusters}()},
\code{\link{cor_cramer}()},
\code{\link{cor_df}()},
\code{\link{cor_matrix}()},
\code{\link{cor_stats}()},
\code{\link{vif}()},
\code{\link{vif_df}()},
\code{\link{vif_stats}()}
}
\concept{multicollinearity_assessment}
