% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_count_rf.R
\name{f_count_rf}
\alias{f_count_rf}
\title{R-squared of Random Forest predictions vs. observations}
\usage{
f_count_rf(df, ...)
}
\arguments{
\item{df}{(required, dataframe) with columns:
\itemize{
\item "x": (numeric, character, factor) predictor.
\item "y" (integer) counts response.
}}

\item{...}{(optional) Accepts the arguments \code{cv_training_fraction} (numeric between 0 and 1) and \code{cv_iterations} (integer between 1 and Inf) for cross validation.}
}
\value{
numeric or numeric vector: R-squared
}
\description{
Fits a univariate random forest model \code{y ~ x} with the integer response \code{y} and the numeric, character or factor predictor \code{x} using \code{ranger::ranger()} and returns the R-squared of the observations against the predictions (see \code{\link[=score_r2]{score_r2()}}).

Supports cross-validation via the arguments arguments \code{cv_training_fraction} (numeric between 0 and 1) and \code{cv_iterations} (integer between 1 and \code{n}) introduced via ellipsis (\code{...}). See \code{\link[=preference_order]{preference_order()}} for further details.
}
\examples{

data(vi_smol)

df <- data.frame(
  y = vi_smol[["vi_counts"]],
  x = vi_smol[["swi_max"]]
)

#no cross-validation
f_count_rf(df = df)

#cross-validation
f_count_rf(
  df = df,
  cv_training_fraction = 0.5,
  cv_iterations = 10
  )

#categorical predictor
df <- data.frame(
  y = vi_smol[["vi_counts"]],
  x = vi_smol[["koppen_zone"]]
)

f_count_rf(df = df)

}
\seealso{
Other preference_order_functions: 
\code{\link{f_binomial_gam}()},
\code{\link{f_binomial_glm}()},
\code{\link{f_binomial_rf}()},
\code{\link{f_categorical_rf}()},
\code{\link{f_count_gam}()},
\code{\link{f_count_glm}()},
\code{\link{f_numeric_gam}()},
\code{\link{f_numeric_glm}()},
\code{\link{f_numeric_rf}()},
\code{\link{preference_order}()}
}
\concept{preference_order_functions}
