% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vif_select.R
\name{vif_select}
\alias{vif_select}
\title{Multicollinearity filtering by variance inflation factor threshold}
\usage{
vif_select(
  df = NULL,
  response = NULL,
  predictors = NULL,
  preference_order = NULL,
  max_vif = 5,
  quiet = FALSE,
  ...
)
}
\arguments{
\item{df}{(required; dataframe, tibble, or sf) A dataframe with responses
(optional) and predictors. Must have at least 10 rows for pairwise
correlation analysis, and \code{10 * (length(predictors) - 1)} for VIF.
Default: NULL.}

\item{response}{(optional; character or NULL) Name of one response variable in \code{df}. Used to exclude columns when \code{predictors} is NULL, and to filter \code{preference_order} when it is a dataframe and contains several responses. Default: NULL.}

\item{predictors}{(optional; character vector or NULL) Names of the
predictors in \code{df}. If NULL, all columns except \code{responses} and
constant/near-zero-variance columns are used. Default: NULL.}

\item{preference_order}{(optional; character vector, dataframe from
\code{\link{preference_order}}, or NULL) Prioritizes predictors to preserve.}

\item{max_vif}{(optional, numeric or NULL) Maximum Variance Inflation Factor allowed for \code{predictors} during multicollinearity filtering. Recommended values are between 2.5 (strict) and 10 (permissive). Default: 5}

\item{quiet}{(optional; logical) If FALSE, messages are printed. Default: FALSE.}

\item{...}{(optional) Internal args (e.g. \code{function_name} for
\code{\link{validate_arg_function_name}}, a precomputed correlation matrix
\code{m}, or cross-validation args for \code{\link{preference_order}}).}
}
\value{
character vector of selected predictors
}
\description{
Wraps \code{\link[=collinear_select]{collinear_select()}} to automatize multicollinearity filtering via variance inflation factors (VIF) in dataframes with numeric and categorical predictors.

The argument \code{max_vif} determines the maximum variance inflation factor allowed in the resulting selection of predictors.

The argument \code{preference_order} accepts a character vector of predictor names ranked from first to last index, or a dataframe resulting from \code{\link[=preference_order]{preference_order()}}. When two predictors in this vector or dataframe are highly collinear, the one with a lower ranking is removed. This option helps protect predictors of interest. If not provided, predictors are ranked from lower to higher multicollinearity.

Please check the sections \strong{Variance Inflation Factors} and \strong{VIF-based Filtering} at the end of this help file for further details.
}
\section{Variance Inflation Factors}{


VIF for predictor \eqn{a} is computed as \eqn{1/(1-R^2)}, where \eqn{R^2} is
the multiple R-squared from regressing \eqn{a} on the other predictors.
Recommended maximums commonly used are 2.5, 5, and 10.
}

\section{VIF-based Filtering}{


\code{\link{vif_select}} ranks numeric predictors (user \code{preference_order}
if provided, otherwise from lower to higher VIF) and sequentially adds
predictors whose VIF against the current selection is below \code{max_vif}.
}

\examples{
data(vi_smol)

## OPTIONAL: parallelization setup
## irrelevant when all predictors are numeric
## only worth it for large data with many categoricals
# future::plan(
#   future::multisession,
#   workers = future::availableCores() - 1
# )

## OPTIONAL: progress bar
# progressr::handlers(global = TRUE)

#predictors
predictors = c(
  "koppen_zone", #character
  "soil_type", #factor
  "topo_elevation", #numeric
  "soil_temperature_mean" #numeric
)

#predictors ordered from lower to higher multicollinearity
x <- vif_select(
  df = vi_smol,
  predictors = predictors,
  max_vif = 5
)

x


#with custom preference order
x <- vif_select(
  df = vi_smol,
  predictors = predictors,
  preference_order = c(
    "koppen_zone",
    "soil_type"
  ),
  max_vif = 5
)

x


#with automated preference order
df_preference <- preference_order(
  df = vi_smol,
  response = "vi_numeric",
  predictors = predictors
)

df_preference

x <- cor_select(
  df = vi_smol,
  predictors = predictors,
  preference_order = df_preference,
  max_cor = 0.7
)

x

## OPTIONAL: disable parallelization
#future::plan(future::sequential)
}
\references{
\itemize{
\item David A. Belsley, D.A., Kuh, E., Welsch, R.E. (1980). Regression Diagnostics: Identifying Influential Data and Sources of Collinearity. John Wiley & Sons. DOI: 10.1002/0471725153.
}
}
\seealso{
Other multicollinearity_filtering: 
\code{\link{collinear}()},
\code{\link{collinear_select}()},
\code{\link{cor_select}()},
\code{\link{step_collinear}()}
}
\author{
Blas M. Benito, PhD
}
\concept{multicollinearity_filtering}
