% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roc_reports.R
\name{roc_reports}
\alias{roc_reports}
\title{Train logistic regression and compute ROC.}
\usage{
roc_reports(
  data,
  markers_table,
  selected_combinations = NULL,
  single_markers = NULL,
  case_class,
  deal_NA = "impute"
)
}
\arguments{
\item{data}{a data.frame returned by load_data().}

\item{markers_table}{a data.frame with combinations and corresponding positive samples counts, obtained with combi().}

\item{selected_combinations}{a numeric vector that specifies the combinations of interest.}

\item{single_markers}{a character vector that specifies the single markers of interest.}

\item{case_class}{a character that specifies which of the two classes of the dataset is the case class.}

\item{deal_NA}{a character that specifies how to treat missing values. With 'impute' NAs of each marker are substituted with the median of that given marker values in the class that observation belongs to. With 'remove' the whole observations containing a NA are removed'.}
}
\value{
a named list containing 3 objects: "Plot", "Metrics" and "Models".
}
\description{
A function to compute General Linear Model (binomial) and the corresponding ROC curves for each selected combination.
}
\details{
This function trains a logistic regression model for each combination and returns a named list containing 3 objects:
\itemize{
\item "Plot": a ggplot object with the ROC curves of the selected combinations.
\item "Metrics": a data.frame with the metrics of the roc curves (AUC, opt. cutoff, etc ...).
\item "Models": the list of models (glm() objects) that have been computed and then used to classify the samples (in which you can find the model equation for each selected combination).
}
}
\examples{
\dontrun{
demo_data # combiroc built-in demo data (proteomics data from Zingaretti et al. 2012 - PMC3518104)

combs <- combi(data= demo_data, signalthr=450, combithr=1, case_class='A')  # compute combinations


# To train logistic regression models on each selected combinations and
# each selected marker, and compute corresponding ROCs.

reports <- roc_reports(data= demo_data, markers_table= combs,
                        selected_combinations= c(1,11,15),
                        single_markers=c('Marker1', 'Marker2'), case_class='A')

reports$Plot  # Shows the ROC curves
reports$Metrics # Shows the ROC metrics
reports$Models # show models
reports$reports$Models$`Combination 11` # show model trained with Combination 11
}
}
