% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_countries.R
\name{list_countries}
\alias{list_countries}
\title{Get the list of countries included in the dataset}
\usage{
list_countries(
  geographic_setting = c("all", "rural", "urban"),
  data_source = c("2020", "2017")
)
}
\arguments{
\item{geographic_setting}{Character. One of "all" (default), "rural", "urban"}

\item{data_source}{Character. Either "202O" (default) or "2017"}
}
\value{
A character vector with the name of all countries included in the
dataset
}
\description{
Get the list of countries included in the dataset
}
\note{
This package uses the nomenclature from the \pkg{countrycode} package.
If your names differ from the names used here, you should use
\pkg{countrycode} as well to update them.
}
\examples{
list_countries()

}
\references{
Kiesha Prem, Alex R. Cook, Mark Jit, \emph{Projecting social contact
matrices in 152 countries using contact surveys and demographic data}, PLoS
Comp. Biol. (2017), \doi{10.1371/journal.pcbi.1005697}

Kiesha Prem, Kevin van Zandvoort, Petra Klepac, Rosalind M. Eggo,
Nicholas G. Davies, CMMID COVID-19 Working Group, Alex R. Cook, Mark Jit,
\emph{Projecting contact matrices in 177 geographical regions: An update and
comparison with empirical data for the COVID-19 era}, PLoS Comp. Biol.
(2021), \doi{10.1371/journal.pcbi.1009098}.
}
