% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_data.R
\name{simulate_contdid_data}
\alias{simulate_contdid_data}
\title{Simulate data for DiD with a Continuous Treatment}
\usage{
simulate_contdid_data(
  n = 5000,
  num_time_periods = 4,
  num_groups = num_time_periods,
  pg = rep(1/num_groups, num_groups - 1),
  pu = 1/(num_groups),
  dose_linear_effect = 0,
  dose_quadratic_effect = 0
)
}
\arguments{
\item{n}{The number of cross-sectional units.  Default is 5000.}

\item{num_time_periods}{The number of time periods.  Default is 4.}

\item{num_groups}{The number of groups.  Default is the number of time periods.
In this case, the groups will consist of a never-treated group and groups
that become treated in every period starting in the second period.}

\item{pg}{A vector of probabilities that a unit will be in a particular treated group.
The default is equal probabilities.}

\item{pu}{The probability that a unit will be in the never-treated group.  The
default is that it is 1/num_groups.}

\item{dose_linear_effect}{The linear effect of the treatment.  Default is 0.}

\item{dose_quadratic_effect}{The quadratic effect of the treatment.  Default is 0.}
}
\value{
A balanced panel data frame with the following columns:
\itemize{
\item id: unit id
\item time_period: time period
\item Y: outcome
\item G: unit's group
\item D: amount of the treatment
}
}
\description{
A function that simulates panel data when there
is a continuous treatment.

Besides the parameters that can be passed to the function, some
values are hard coded.  The individual fixed effect is drawn from a
normal distribution with mean equal to the group.  The time effects
are hard coded to be equal to the time period.  The dose
is drawn from a uniform distribution between 0 and 1.
}
