% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/word_distribution.R
\name{plot_word_distribution}
\alias{plot_word_distribution}
\title{Create interactive word distribution plot}
\usage{
plot_word_distribution(
  word_distribution_data,
  plot_type = "line",
  smooth = FALSE,
  show_points = TRUE,
  colors = NULL
)
}
\arguments{
\item{word_distribution_data}{Tibble from calculate_word_distribution()}

\item{plot_type}{Character. "line" or "area" (default: "line").}

\item{smooth}{Logical. Apply smoothing to lines (default: FALSE).}

\item{show_points}{Logical. Show data points on lines (default: TRUE).}

\item{colors}{Character vector. Custom colors for words (optional).}
}
\value{
A plotly object with interactive visualization.
}
\description{
Creates an interactive plotly visualization of word frequencies across
document segments or sections.
}
\details{
The plot shows:
\itemize{
\item X-axis: Document sections or segments
\item Y-axis: Relative frequency (percentage)
\item Each word as a separate line/area
\item Hover information with exact values
}
}
\examples{
\dontrun{
dist <- calculate_word_distribution(doc, c("method", "result", "conclusion"))
plot_word_distribution(dist, plot_type = "line", show_points = TRUE)

# Area plot with custom colors
plot_word_distribution(dist, plot_type = "area",
                      colors = c("#FF6B6B", "#4ECDC4", "#45B7D1"))
}

}
