% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/care.R
\name{care}
\alias{care}
\title{Continuous-time Algebraic Riccati Equation solution}
\usage{
care(A, B, Q, R = 1)
}
\arguments{
\item{A}{State-matrix of a state-space system}

\item{B}{Input-matrix of a state-space system}

\item{Q}{Symmetric output-matrix of a state-space system}

\item{R}{Single number}
}
\value{
Returns the stabilizing matrix, gain and closed-loop eigenvalues in a list.
}
\description{
Computes the unique solution to the continuous-time Riccati equation:

       A'* X + X*A - X * B * R^-1 * B' * X + Q'*Q = 0
}
\details{
\code{X <- care(A, B, Q, R)} returns the stablizing solution (if it
exists) to the continuous-time Riccati equation.

The \code{care} function also returns the gain matrix, \code{G}
and a vector, \code{L} of the closed-loop eigenvalues, where

G = R^-1 B'X*E

\code{L = eig(a-b*g)}
}
\note{
A, B must be controllable
}
\examples{
a <- matrix(c(-3, 2,1, 1), byrow = TRUE, ncol = 2)
b <- matrix(c(0, 1), nrow = 2)
c <- matrix(c(1, -1), ncol = 2)
q <- t(c)\%*\%c
r <- 3
care(a, b, q, r)
}
