% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_functions.R
\name{occurrence_terms}
\alias{occurrence_terms}
\alias{event_terms}
\title{Select support functions}
\usage{
occurrence_terms()

event_terms()
}
\value{
A vector of accepted (but not mandatory) values for that use case.
}
\description{
When creating a Darwin Core archive, it is often useful to select only those
fields that conform to the standard. These functions provide a vector of
terms that can be used in combination with \code{\link[dplyr:select]{dplyr::select()}} and
\code{\link[dplyr:reexports]{dplyr::any_of()}} to quickly select Darwin Core terms for the relevant
data type (events, occurrences, media).
}
\examples{
# Return a vector of accepted terms in an Occurrence-based dataset
occurrence_terms() |> head(10L) # first 10 terms

# Use this vector to filter a data frame
df <- tibble::tibble(
  name = c("Crinia Signifera", "Crinia Signifera", "Litoria peronii"),
  latitude = c(-35.27, -35.24, -35.83),
  longitude = c(149.33, 149.34, 149.34),
  eventDate = c("2010-10-14", "2010-10-14", "2010-10-14"),
  measurement1 = c(24.3, 24.9, 20.1), # example measurement column
  measurement2 = c(0.92, 1.03, 1.09)  # example measurement column
  )

df |>
  dplyr::select(any_of(occurrence_terms()))

}
\seealso{
\code{\link[=basisOfRecord_values]{basisOfRecord_values()}} or \code{\link[=countryCode_values]{countryCode_values()}} for valid entries
\emph{within} a field.
}
