% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_differentialTest.R
\name{plot.differentialTest}
\alias{plot.differentialTest}
\title{differentialTest plot function}
\usage{
\method{plot}{differentialTest}(x, level = NULL, data_only = FALSE, ...)
}
\arguments{
\item{x}{Object of class \code{differentialTest}}

\item{level}{(Optional). Character vector. Desired taxonomic levels for taxa labels.}

\item{data_only}{(Optional). Default \code{FALSE}. Boolean. If \code{TRUE}, only returns data frame.}

\item{...}{No optional arguments are accepted at this time.}
}
\value{
Object of class \code{ggplot}. Plot of coefficients from models for significant taxa from \code{differentialTest}
}
\description{
differentialTest plot function
}
\examples{
# phyloseq example
data(soil_phylum_small_sample)
data(soil_phylum_small_otu)
da_analysis <- differentialTest(formula = ~ DayAmdmt,
                                phi.formula = ~ DayAmdmt,
                                formula_null = ~ 1,
                                phi.formula_null = ~ DayAmdmt,
                                test = "Wald", boot = FALSE,
                                data = soil_phylum_small_otu,
                                sample_data = soil_phylum_small_sample,
                                fdr_cutoff = 0.05,
                                try_only = 1:5)
plot(da_analysis, level = "Phylum")

}
