# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Estimate the mean for a STAR process
#'
#' Estimate the conditional expectation for a STAR process
#' under a generic link function g.
#'
#' @param g_a_j \code{Jmax x 1} vector of g(a(j))
#' @param g_a_jp1 \code{Jmax x 1} vector of g(a(j + 1))
#' @param mu \code{m x 1} vector of conditional expectations
#' @param sigma \code{m x 1} vector of conditional standard deviations
#' @param Jmax \code{m x 1} vector of maximum integer values to consider
#'
#' @return y_hat \code{m x 1} vector of conditional expectations
#'
#' @note This function uses \code{Rcpp} for computational efficiency.
#'
#' @useDynLib countSTAR
#' @import Rcpp
#' @keywords internal
expectation_gRcpp <- function(g_a_j, g_a_jp1, mu, sigma, Jmax) {
    .Call('_countSTAR_expectation_gRcpp', PACKAGE = 'countSTAR', g_a_j, g_a_jp1, mu, sigma, Jmax)
}

#' Estimate confidence intervals/bands for a STAR process
#'
#' Compute confidence intervals/bands for the expected value of the count-valued STAR process \code{y}
#' based on intervals/bands for the Gaussian process \code{mu}.
#'
#' @param g_a_j \code{Jmax x 1} vector of g(a(j))
#' @param g_a_jp1 \code{Jmax x 1} vector of g(a(j + 1))
#' @param L_mu \code{m x 1} vector of lower intervals for \code{mu}
#' @param U_mu \code{m x 1} vector of upper intervals for \code{mu}
#' @param sigma \code{m x 1} vector of conditional standard deviations
#' @param Jmax \code{m x 1} vector of maximum integer values to consider
#'
#' @return LU_y \code{m x 2} vector of intervals for \code{y}.
#'
#' @note This function uses \code{Rcpp} for computational efficiency.
#'
#' @useDynLib countSTAR
#' @import Rcpp
#' @keywords internal
interval_gRcpp <- function(g_a_j, g_a_jp1, L_mu, U_mu, sigma, Jmax) {
    .Call('_countSTAR_interval_gRcpp', PACKAGE = 'countSTAR', g_a_j, g_a_jp1, L_mu, U_mu, sigma, Jmax)
}

#' Sample from a truncated normal distribution
#'
#' Sample from a truncated normal distribution. Samples are drawn
#' componentwise, so each component of the vector is allowed its own
#' mean, standard deviation, and upper and lower limits. The components
#' are assumed to be independent.
#'
#' @param y_lower \code{m x 1} vector of lower endpoints
#' @param y_upper \code{m x 1} vector of upper endpoints
#' @param mu \code{m x 1} vector of conditional expectations
#' @param sigma \code{m x 1} vector of conditional standard deviations
#' @param u_rand \code{m x 1} vector of uniform random variables
#'
#' @return z_star \code{m x 1} draw from the truncated normal distribution
#'
#' @note This function uses \code{Rcpp} for computational efficiency.
#'
#' @useDynLib countSTAR
#' @import Rcpp
#' @keywords internal
rtruncnormRcpp <- function(y_lower, y_upper, mu, sigma, u_rand) {
    .Call('_countSTAR_rtruncnormRcpp', PACKAGE = 'countSTAR', y_lower, y_upper, mu, sigma, u_rand)
}

#' Compute the log-likelihood for STAR
#'
#' Compute the log-likelihood for a STAR model. The code here assumes
#' that the transformed real-valued process (z_star) has conditionally independent
#' components with means \code{mu} and standard deviations \code{sigma}.
#'
#' @param g_a_j \code{m x 1} vector of g(a(j))
#' @param g_a_jp1 \code{m x 1} vector of g(a(j + 1))
#' @param mu \code{m x 1} vector of conditional expectations
#' @param sigma \code{m x 1} vector of conditional standard deviations
#' @return loglike scalar log-likelihood value
#'
#' @note This function uses \code{Rcpp} for computational efficiency.
#'
#' @useDynLib countSTAR
#' @import Rcpp
#' @keywords internal
logLikeRcpp <- function(g_a_j, g_a_jp1, mu, sigma) {
    .Call('_countSTAR_logLikeRcpp', PACKAGE = 'countSTAR', g_a_j, g_a_jp1, mu, sigma)
}

#' Compute the pointwise log-likelihood for STAR
#'
#' Compute the pointwise log-likelihood for a STAR model. The code here assumes
#' that the transformed real-valued process (z_star) has conditionally independent
#' components with means \code{mu} and standard deviations \code{sigma}.
#'
#' @param g_a_j \code{m x 1} vector of g(a(j))
#' @param g_a_jp1 \code{m x 1} vector of g(a(j + 1))
#' @param mu \code{m x 1} vector of conditional expectations
#' @param sigma \code{m x 1} vector of conditional standard deviations
#' @return loglike \code{m x 1} log-likelihood value
#'
#' @note This function uses \code{Rcpp} for computational efficiency.
#'
#' @useDynLib countSTAR
#' @import Rcpp
#' @keywords internal
logLikePointRcpp <- function(g_a_j, g_a_jp1, mu, sigma) {
    .Call('_countSTAR_logLikePointRcpp', PACKAGE = 'countSTAR', g_a_j, g_a_jp1, mu, sigma)
}

#' Compute E(Y^2) for a STAR process
#'
#' Compute the conditional expectation of Y^2 for a STAR process Y
#' under a generic link function g.
#'
#' @param g_a_j \code{Jmax x 1} vector of g(a(j))
#' @param g_a_jp1 \code{Jmax x 1} vector of g(a(j + 1))
#' @param mu \code{m x 1} vector of conditional expectations
#' @param sigma \code{m x 1} vector of conditional standard deviations
#' @param Jmax \code{m x 1} vector of maximum integer values to consider
#'
#' @return y2_hat \code{m x 1} vector of conditional expectations
#'
#' @note This function uses \code{Rcpp} for computational efficiency.
#'
#' @useDynLib countSTAR
#' @import Rcpp
#' @keywords internal
expectation2_gRcpp <- function(g_a_j, g_a_jp1, mu, sigma, Jmax) {
    .Call('_countSTAR_expectation2_gRcpp', PACKAGE = 'countSTAR', g_a_j, g_a_jp1, mu, sigma, Jmax)
}

#' pmax() in Rcpp
#'
#' Compute the pointwise max for two vectors of equal length
#'
#' @param v1 \code{m x 1} vector
#' @param v2 \code{m x 1} vector
#' @return vm \code{m x 1} vector of pointwise maxima
#'
#' @note This function uses \code{Rcpp} for computational efficiency.
#'
#' @useDynLib countSTAR
#' @import Rcpp
#' @keywords internal
pmaxRcpp <- function(v1, v2) {
    .Call('_countSTAR_pmaxRcpp', PACKAGE = 'countSTAR', v1, v2)
}

#' pmin() in Rcpp
#'
#' Compute the pointwise min for two vectors of equal length
#'
#' @param v1 \code{m x 1} vector
#' @param v2 \code{m x 1} vector
#' @return vm \code{m x 1} vector of pointwise minima
#'
#' @note This function uses \code{Rcpp} for computational efficiency.
#'
#' @useDynLib countSTAR
#' @import Rcpp
#' @keywords internal
pminRcpp <- function(v1, v2) {
    .Call('_countSTAR_pminRcpp', PACKAGE = 'countSTAR', v1, v2)
}

#' Estimate the mean for a STAR process
#'
#' Estimate the conditional expectation for a STAR process
#' under the identity link function.
#'
#' @param a \code{Jmaxmax}-dimensional vector of STAR integers a_j
#' @param Jmax \code{T x m} matrix of maximum integer values to consider
#' @param Mu \code{T x m} matrix of latent means
#' @param sigma_t \code{T}-dimensional vector of time-dependent latent error sd's
#' @param Offset \code{T x m} matrix of offsets
#' @return Zhat \code{T x m} matrix of conditional expectations
#'
#' @note This function uses \code{Rcpp} for computational efficiency.
#'
#' @useDynLib countSTAR
#' @import Rcpp
#' @keywords internal
expectation_identity <- function(a, Jmax, Mu, sigma_t, Offset) {
    .Call('_countSTAR_expectation_identity', PACKAGE = 'countSTAR', a, Jmax, Mu, sigma_t, Offset)
}

#' Estimate the mean for a STAR process
#'
#' Estimate the conditional expectation for a STAR process
#' under the log link function.
#'
#' @param a \code{Jmaxmax}-dimensional vector of STAR integers a_j
#' @param Jmax \code{T x m} matrix of maximum integer values to consider
#' @param Mu \code{T x m} matrix of latent means
#' @param sigma_t \code{T}-dimensional vector of time-dependent latent error sd's
#' @param Offset \code{T x m} matrix of offsets
#' @return Zhat \code{T x m} matrix of conditional expectations
#'
#' @note This function uses \code{Rcpp} for computational efficiency.
#'
#' @useDynLib countSTAR
#' @import Rcpp
#' @keywords internal
expectation_log <- function(a, Jmax, Mu, sigma_t, Offset) {
    .Call('_countSTAR_expectation_log', PACKAGE = 'countSTAR', a, Jmax, Mu, sigma_t, Offset)
}

#' Estimate the mean for a STAR process
#'
#' Estimate the conditional expectation for a STAR process
#' under the square root link function.
#'
#' @param a \code{Jmaxmax}-dimensional vector of STAR integers a_j
#' @param Jmax \code{T x m} matrix of maximum integer values to consider
#' @param Mu \code{T x m} matrix of latent means
#' @param sigma_t \code{T}-dimensional vector of time-dependent latent error sd's
#' @param Offset \code{T x m} matrix of offsets
#' @return Zhat \code{T x m} matrix of conditional expectations
#'
#' @note This function uses \code{Rcpp} for computational efficiency.
#'
#' @useDynLib countSTAR
#' @import Rcpp
#' @keywords internal
expectation_sqrt <- function(a, Jmax, Mu, sigma_t, Offset) {
    .Call('_countSTAR_expectation_sqrt', PACKAGE = 'countSTAR', a, Jmax, Mu, sigma_t, Offset)
}

