% Generated by roxygen2: do not edit by hand
\name{fpkmheatmap}
\alias{fpkmheatmap}
\title{
\packageTitle{countToFPKM}
A FPKM heatmap plot of the highly variable features in RNA-Seq dataset
}

\usage{
fpkmheatmap(fpkm_matrix, topvar=30, showfeaturenames=TRUE, return_log = TRUE)
}

\arguments{
\item{fpkm_matrix}{A data matrix normalized by library size and feature length.}
\item{topvar}{Number of highly variable features to show in heatmap plot.}
\item{showfeaturenames}{whether to show the name of features in heatmap plot.
The default value is \code{TRUE}.}
\item{return_log}{whether to use log10 transformation of (fpkm+1).
The default value is \code{TRUE}.}
}

\value{
A FPKM heatmap plot of the highly variable features in RNA-Seq dataset.
}

\description{
fpkmheatmap() function returns a heatmap plot of the highly variable features in RNA-Seq dataset.
}

\references{
Trapnell,C. et al. (2010) Transcript assembly and quantification by RNA-seq reveals unannotated transcripts and isoform switching during cell differentiation. 
Nat. Biotechnol., 28, 511-515. doi: 10.1038/nbt.1621.
}

\details{
The fpkmheatmap() function provides the user with a quick and reliable way to generate FPKM heatmap plot of the highly variable features in RNA-Seq dataset. It takes an FPKM numeric matrix which can be obtained using the fpkm() function as input. By default using Pearson correlation - 1 to measure the distance between features, and Spearman correlation -1 for clustering of samples. By default log10 transformation of (FPKM+1) is applied to make variation similar across orders of magnitude. It then uses the var() function to identify the highly variable features to create the heatmap plot using the Heatmap() function from the 'ComplexHeatmap' package.
}
\examples{
library(countToFPKM)

file.readcounts <- system.file("extdata", "RNA-seq.read.counts.csv", package="countToFPKM")
file.annotations <- system.file("extdata", "Biomart.annotations.hg38.txt", package="countToFPKM")
file.sample.metrics <- system.file("extdata", "RNA-seq.samples.metrics.txt", package="countToFPKM")


# Import the read count matrix data into R.
counts <- as.matrix(read.csv(file.readcounts))

# Import feature annotations. 
# Assign feature length into a numeric vector.
gene.annotations <- read.table(file.annotations, sep="\t", header=TRUE)
featureLength <- gene.annotations$length

# Import sample metrics. 
# Assign mean fragment length into a numeric vector.
samples.metrics <- read.table(file.sample.metrics, sep="\t", header=TRUE)
meanFragmentLength <- samples.metrics$meanFragmentLength

# Return FPKM into a numeric matrix.
fpkm_matrix <- fpkm (counts, featureLength, meanFragmentLength)

# Plot log10(FPKM+1) heatmap of top 30 highly variable features
fpkmheatmap(fpkm_matrix, topvar=30, showfeaturenames=TRUE, return_log = TRUE)
}

