% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_p_values.R
\name{compute_p_values}
\alias{compute_p_values}
\title{Compute p-values for each target ID}
\usage{
compute_p_values(
  cpo,
  subset = NULL,
  p_adj_method = "BH",
  gam_method = "REML",
  gam_optimizer = "efs",
  silent = TRUE
)
}
\arguments{
\item{cpo}{a cpam object}

\item{subset}{a character vector of target_id names}

\item{p_adj_method}{method for p-value adjustment}

\item{gam_method}{fitting method for \code{mgcv::gam} (default is "REML")}

\item{gam_optimizer}{optimization method for \code{mgcv::gam} (default is "efs")}

\item{silent}{logical; silences warnings from model fitting (default is TRUE)}
}
\value{
an updated cpam object with raw, adjusted, and possibly aggregated p-values stored in the new slot "p_table"
}
\description{
Compute p-values for each target ID
}
\details{
This function computes p-values for each target_id in the supplied cpam object.
The p-values are computed from a negative binomial GAM model
with a thin-plate spline basis function(s) for time
using the \code{mgcv} package.

The p-values are stored in the new slot \code{p_table} in the cpam object.
If \code{aggregate_to_gene} is set to \code{TRUE} (default),
the target p-values are aggregated to the gene level using the \code{lancaster} method.
The columns \code{p_val_target} and \code{p_val_gene} store the raw p-values for target- and gene-level, respectively.
The function also computes adjusted p-values using the \code{p_adj_method}.
The default method is "BH" (Benjamini-Hochberg),
but any methods supported by the function \code{p.adjust} can be used.
The adjusted p-values are stored in the columns \code{q_val_target} and \code{q_val_gene}.
}
\examples{
library(cpam)

# load gene-only example cpam object
load(system.file("extdata", "cpo_example.rda", package = "cpam"))

# run on a small subset of the example data
cpo <- compute_p_values(cpo_example, subset = paste0("g00",1:9))
cpo$p_table

}
\references{
Wood, S.N. (2013a) On p-values for smooth components of an extended
generalized additive model. Biometrika 100:221-228 doi:10.1093/biomet/ass048

Yi L, Pachter L (2018). aggregation: p-Value Aggregation Methods. R package version 1.0.1,
https://CRAN.R-project.org/package=aggregation.
}
