% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.r
\name{read_bigwig}
\alias{read_bigwig}
\title{Read data from bigWig files.}
\usage{
read_bigwig(bwfile, chrom = NULL, start = NULL, end = NULL, as = NULL)
}
\arguments{
\item{bwfile}{filename for bigWig file}

\item{chrom}{read data for specific chromosome}

\item{start}{start position for data}

\item{end}{end position for data}

\item{as}{return data as a specific type.
The default is a tibble (\code{tbl}) or GRanges (\code{gr})}
}
\value{
\code{tibble}
}
\description{
Read data from bigWig files.
}
\examples{
bw <- system.file("extdata", "test.bw", package = "cpp11bigwig")

read_bigwig(bw)

read_bigwig(bw, chrom = "10")

read_bigwig(bw, chrom = "1", start = 100, end = 130)

read_bigwig(bw, as = "GRanges")

}
\seealso{
\url{https://github.com/dpryan79/libBigWig}

\url{https://github.com/brentp/bw-python}
}
