% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_doc.R
\docType{data}
\name{cps_cols}
\alias{cps_cols}
\title{Sample column specifications for reading CPS data}
\format{
A data frame with 204 rows and 8 columns:
\describe{
\item{year}{year}
\item{cps_name}{original column name as given by the CPS}
\item{new_name}{a new name, which tries to describe the variable and join
sensibly across multiple years}
\item{start_pos}{which character of a line the variable starts with}
\item{end_pos}{which character of a line the variable ends with}
\item{col_type}{whether the column is character, numeric, or a factor}
\item{description}{the question text/description from the CPS}
\item{notes}{any notes for question administration or analysis}
}
}
\usage{
cps_cols
}
\description{
Because the CPS is a fixed-width file that changes data locations (and variable
names) across years, to correctly read the data you have to specify which
start/end positions correspond to which column names in each year. This is one
such specification. To add extra data or change column names, see the Vignette.
}
\keyword{datasets}
