% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sch_relation.R
\name{sch_add_relations}
\alias{sch_add_relations}
\title{Add Relations}
\usage{
sch_add_relations(sch, from, to, type = "FS", lag = 0L, ...)
}
\arguments{
\item{sch}{A schedule object.}

\item{from}{The id of predecessor activity.}

\item{to}{The id of successor activity.}

\item{type}{Specifies the relation type between activities.
The default type is FS and its value may be: FS, FF, SS, SF.}

\item{lag}{The time period between activities that the successor activity
\code{to} must be advanced after activity \code{from}  has been finished.}

\item{...}{One or more vectors for associated relation attributes.}
}
\value{
A schedule with a relation tibble (rtb) added.
}
\description{
Combine several vectors for relation and their attributes into a tibble
and add relations between activities to a schedule.
}
\details{
An relation tibble, or rtb, has at least the following columns:
\itemize{
\item \code{from} (of type \code{integer}): The id of predecessor activity.
Must exist an activity with \code{from} id.
\item \code{to} (of type \code{integer}): The id of successor activity.
Must exist an activity with \code{to} id.
\item \code{type} (of type \code{character})
Specifies the relation type between activities.
The default type is FS and its value may be: FS, FF, SS, SF, that means:
\itemize{
\item \strong{FS:} Finish-Start relation.
Activity 'to' id can only start after the finish of activity 'from' id.
\item \strong{FF:} Finish-Finish relation.
Activity 'to' id must finish together with activity 'from' id.
\item \strong{SS:} Start-Start relation.
Activity 'to' id must start together with activity 'from' id.
\item \strong{SF:} Start-Finish relation.
Activity 'to' id must finish when activity 'from' id starts.
}
\item \code{lag} (of type \code{integer}): The time period between activities
that the successor activity \code{to} must be advanced after activity \code{from}
has been finished.
The value may be negative, in such case, the activity 'to' will be
anticipated 'lag' time periods.
It must be an integer, less than, equal or greater than zero.
If lag is not defined, it is assumed to be zero.
}

An arbitrary number of additional columns containing data attributes can be
part of the rtb, so long as they follow the aforementioned columns.
}
\examples{
sch <- sch_new() \%>\%
  sch_title("Project 1: Cost Information System") \%>\%
  sch_reference(
    "VANHOUCKE, Mario. Integrated project management and control:
    first comes the theory, then the practice.Gent: Springer, 2014, p. 6"
  ) \%>\%
  sch_add_activities(
    id        = 1:17,
    name      = paste("a", as.character(1:17), sep=""),
    duration  = c(1L,2L,2L,4L,3L,3L,3L,2L,1L,1L,2L,1L,1L,1L,1L,2L,1L)
  ) \%>\%
  sch_plan()
sch_has_any_relation(sch) # FALSE
sch_nr_relations(sch) # 0
sch_duration(sch) # 4

sch \%<>\%
  sch_add_relations(
    from = c(1L, 1L, 2L, 2L, 2L, 3L, 3L, 3L,  3L,  4L,  5L,  6L,
             7L,  8L,  9L, 10L, 11L, 11L, 12L, 12L, 13L, 13L, 14L, 14L, 15L, 15L),
    to   = c(2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L, 11L, 11L, 11L,
             12L, 13L, 14L, 15L, 16L, 17L, 16L, 17L, 16L, 17L, 16L, 17L, 16L, 17L)
  ) \%>\%
  sch_plan()
sch_has_any_relation(sch) # TRUE
sch_nr_relations(sch) # 26
sch_duration(sch) # 11

}
\seealso{
\code{\link[=sch_title]{sch_title()}}, \code{\link[=sch_reference]{sch_reference()}}, \code{\link[=sch_add_relation]{sch_add_relation()}},
\code{\link[=sch_nr_relations]{sch_nr_relations()}}, \code{\link[=sch_has_any_relation]{sch_has_any_relation()}}, \code{\link[=sch_new]{sch_new()}}, \code{\link[=sch_plan]{sch_plan()}},
\code{\link[=sch_add_activities]{sch_add_activities()}}, \code{\link[=sch_validate]{sch_validate()}}.
}
