% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_knitr_CohortSize.R,
%   R/helpers_knitr_Design.R, R/helpers_knitr_GeneralData.R,
%   R/helpers_knitr_GeneralModel.R, R/helpers_knitr_Increments.R,
%   R/helpers_knitr_NextBest.R, R/helpers_knitr_SafetyWindow.R,
%   R/helpers_knitr_Stopping.R
\name{knit_print}
\alias{knit_print}
\alias{knit_print.CohortSizeConst}
\alias{knit_print.CohortSizeRange}
\alias{knit_print.CohortSizeDLT}
\alias{knit_print.CohortSizeParts}
\alias{knit_print.CohortSizeMax}
\alias{knit_print.CohortSizeMin}
\alias{knit_print.CohortSizeOrdinal}
\alias{knit_print.StartingDose}
\alias{knit_print.RuleDesign}
\alias{knit_print.Design}
\alias{knit_print.DualDesign}
\alias{knit_print.DADesign}
\alias{knit_print.TDDesign}
\alias{knit_print.DualResponsesDesign}
\alias{knit_print.DesignOrdinal}
\alias{knit_print.DesignGrouped}
\alias{knit_print.TDsamplesDesign}
\alias{knit_print.DualResponsesSamplesDesign}
\alias{knit_print.RuleDesignOrdinal}
\alias{knit_print.GeneralData}
\alias{knit_print.DataParts}
\alias{knit_print.DualEndpoint}
\alias{knit_print.ModelParamsNormal}
\alias{knit_print.GeneralModel}
\alias{knit_print.LogisticKadane}
\alias{knit_print.LogisticKadaneBetaGamma}
\alias{knit_print.LogisticLogNormal}
\alias{knit_print.LogisticLogNormalMixture}
\alias{knit_print.LogisticLogNormalSub}
\alias{knit_print.LogisticNormalMixture}
\alias{knit_print.LogisticNormalFixedMixture}
\alias{knit_print.OneParLogNormalPrior}
\alias{knit_print.OneParExpPrior}
\alias{knit_print.LogisticLogNormalGrouped}
\alias{knit_print.LogisticLogNormalOrdinal}
\alias{knit_print.LogisticIndepBeta}
\alias{knit_print.Effloglog}
\alias{knit_print.IncrementsRelative}
\alias{knit_print.IncrementsRelativeDLT}
\alias{knit_print.IncrementsDoseLevels}
\alias{knit_print.IncrementsHSRBeta}
\alias{knit_print.IncrementsMin}
\alias{knit_print.IncrementsOrdinal}
\alias{knit_print.IncrementsRelativeParts}
\alias{knit_print.IncrementsRelativeDLTCurrent}
\alias{knit_print.NextBestMTD}
\alias{knit_print.NextBestNCRM}
\alias{knit_print.NextBestThreePlusThree}
\alias{knit_print.NextBestDualEndpoint}
\alias{knit_print.NextBestMinDist}
\alias{knit_print.NextBestInfTheory}
\alias{knit_print.NextBestTD}
\alias{knit_print.NextBestMaxGain}
\alias{knit_print.NextBestProbMTDLTE}
\alias{knit_print.NextBestProbMTDMinDist}
\alias{knit_print.NextBestNCRMLoss}
\alias{knit_print.NextBestTDsamples}
\alias{knit_print.NextBestMaxGainSamples}
\alias{knit_print.NextBestOrdinal}
\alias{knit_print.SafetyWindow}
\alias{knit_print.SafetyWindowConst}
\alias{knit_print.SafetyWindowSize}
\alias{knit_print.StoppingOrdinal}
\alias{knit_print.StoppingMaxGainCIRatio}
\alias{knit_print.StoppingList}
\alias{knit_print.StoppingAny}
\alias{knit_print.StoppingAll}
\alias{knit_print.StoppingTDCIRatio}
\alias{knit_print.StoppingTargetBiomarker}
\alias{knit_print.StoppingLowestDoseHSRBeta}
\alias{knit_print.StoppingMTDCV}
\alias{knit_print.StoppingMTDdistribution}
\alias{knit_print.StoppingHighestDose}
\alias{knit_print.StoppingSpecificDose}
\alias{knit_print.StoppingTargetProb}
\alias{knit_print.StoppingMinCohorts}
\alias{knit_print.StoppingMinPatients}
\alias{knit_print.StoppingPatientsNearDose}
\alias{knit_print.StoppingCohortsNearDose}
\alias{knit_print.StoppingMissingDose}
\title{Render a \code{CohortSizeConst} Object}
\usage{
\method{knit_print}{CohortSizeConst}(x, ..., asis = TRUE, label = c("participant", "participants"))

\method{knit_print}{CohortSizeRange}(x, ..., asis = TRUE)

\method{knit_print}{CohortSizeDLT}(x, ..., tox_label = "toxicity", asis = TRUE)

\method{knit_print}{CohortSizeParts}(x, ..., asis = TRUE, label = c("participant", "participants"))

\method{knit_print}{CohortSizeMax}(x, ..., asis = TRUE)

\method{knit_print}{CohortSizeMin}(x, ..., asis = TRUE)

\method{knit_print}{CohortSizeOrdinal}(x, ..., tox_label = "toxicity", asis = TRUE)

\method{knit_print}{StartingDose}(x, ..., asis = TRUE)

\method{knit_print}{RuleDesign}(x, ..., level = 2L, title = "Design", sections = NA, asis = TRUE)

\method{knit_print}{Design}(x, ..., level = 2L, title = "Design", sections = NA, asis = TRUE)

\method{knit_print}{DualDesign}(x, ..., level = 2L, title = "Design", sections = NA, asis = TRUE)

\method{knit_print}{DADesign}(x, ..., level = 2L, title = "Design", sections = NA, asis = TRUE)

\method{knit_print}{TDDesign}(x, ..., level = 2L, title = "Design", sections = NA, asis = TRUE)

\method{knit_print}{DualResponsesDesign}(x, ..., level = 2L, title = "Design", sections = NA, asis = TRUE)

\method{knit_print}{DesignOrdinal}(x, ..., level = 2L, title = "Design", sections = NA, asis = TRUE)

\method{knit_print}{DesignGrouped}(
  x,
  ...,
  level = 2L,
  title = "Design",
  sections = c(model = "Dose toxicity model", mono = "Monotherapy rules", combo =
    "Combination therapy rules", other = "Other details"),
  asis = TRUE
)

\method{knit_print}{TDsamplesDesign}(x, ..., level = 2L, title = "Design", sections = NA, asis = TRUE)

\method{knit_print}{DualResponsesDesign}(x, ..., level = 2L, title = "Design", sections = NA, asis = TRUE)

\method{knit_print}{DualResponsesSamplesDesign}(x, ..., level = 2L, title = "Design", sections = NA, asis = TRUE)

\method{knit_print}{RuleDesignOrdinal}(x, ..., level = 2L, title = "Design", sections = NA, asis = TRUE)

\method{knit_print}{GeneralData}(
  x,
  ...,
  asis = TRUE,
  label = c("participant", "participants"),
  full_grid = FALSE,
  summarise = c("none", "dose", "cohort"),
  summarize = summarise,
  units = NA,
  format_func = h_knit_format_func
)

\method{knit_print}{DataParts}(
  x,
  ...,
  asis = TRUE,
  label = c("participant", "participants"),
  full_grid = FALSE,
  summarise = c("none", "dose", "cohort"),
  summarize = summarise,
  units = NA,
  format_func = h_knit_format_func
)

\method{knit_print}{DualEndpoint}(
  x,
  ...,
  asis = TRUE,
  use_values = TRUE,
  fmt = "\%5.2f",
  units = NA,
  tox_label = "toxicity",
  biomarker_label = "PD biomarker"
)

\method{knit_print}{ModelParamsNormal}(
  x,
  use_values = TRUE,
  fmt = "\%5.2f",
  params = c("alpha", "beta"),
  preamble = "The prior for &theta; is given by\\\\n",
  asis = TRUE,
  theta = "\\\\theta",
  ...
)

\method{knit_print}{GeneralModel}(
  x,
  ...,
  params = c("alpha", "beta"),
  asis = TRUE,
  use_values = TRUE,
  fmt = "\%5.2f",
  units = NA
)

\method{knit_print}{LogisticKadane}(
  x,
  ...,
  asis = TRUE,
  use_values = TRUE,
  fmt = "\%5.2f",
  units = NA,
  tox_label = "toxicity"
)

\method{knit_print}{LogisticKadaneBetaGamma}(
  x,
  ...,
  asis = TRUE,
  use_values = TRUE,
  fmt = "\%5.2f",
  tox_label = "toxicity",
  units = NA
)

\method{knit_print}{LogisticLogNormal}(
  x,
  ...,
  use_values = TRUE,
  fmt = "\%5.2f",
  params = c(`\\\\alpha` = "alpha", `log(\\\\beta)` = "beta"),
  preamble = "The prior for &theta; is given by\\\\n",
  asis = TRUE
)

\method{knit_print}{LogisticLogNormalMixture}(x, ..., asis = TRUE, use_values = TRUE, fmt = "\%5.2f", units = NA)

\method{knit_print}{LogisticLogNormalSub}(
  x,
  ...,
  use_values = TRUE,
  fmt = "\%5.2f",
  params = c(`\\\\alpha` = "alpha", `log(\\\\beta)` = "beta"),
  preamble = "The prior for &theta; is given by\\\\n",
  asis = TRUE
)

\method{knit_print}{LogisticNormalMixture}(x, ..., asis = TRUE, use_values = TRUE, fmt = "\%5.2f", units = NA)

\method{knit_print}{LogisticNormalFixedMixture}(x, ..., asis = TRUE, use_values = TRUE, fmt = "\%5.2f", units = NA)

\method{knit_print}{OneParLogNormalPrior}(
  x,
  ...,
  tox_label = "toxicity",
  asis = TRUE,
  use_values = TRUE,
  fmt = "\%5.2f"
)

\method{knit_print}{OneParExpPrior}(x, ..., asis = TRUE)

\method{knit_print}{LogisticLogNormalGrouped}(
  x,
  ...,
  use_values = TRUE,
  fmt = "\%5.2f",
  params = c(`\\\\alpha` = "alpha", `\\\\beta` = "beta", `log(\\\\delta_0)` = "delta_0",
    `log(\\\\delta_1)` = "delta_1"),
  preamble = "The prior for &theta; is given by\\\\n",
  asis = TRUE
)

\method{knit_print}{LogisticLogNormalOrdinal}(
  x,
  ...,
  use_values = TRUE,
  fmt = "\%5.2f",
  params = NA,
  preamble = "The prior for &theta; is given by\\\\n",
  asis = TRUE
)

\method{knit_print}{LogisticIndepBeta}(
  x,
  ...,
  use_values = TRUE,
  fmt = "\%5.2f",
  params = NA,
  tox_label = "DLAE",
  preamble = "The prior for &theta; is given by\\\\n",
  asis = TRUE
)

\method{knit_print}{Effloglog}(
  x,
  ...,
  use_values = TRUE,
  fmt = "\%5.2f",
  params = NA,
  tox_label = "DLAE",
  eff_label = "efficacy",
  label = "participant",
  preamble = "The prior for &theta; is given by\\\\n",
  asis = TRUE
)

\method{knit_print}{IncrementsRelative}(x, ..., asis = TRUE)

\method{knit_print}{IncrementsRelativeDLT}(x, ..., asis = TRUE)

\method{knit_print}{IncrementsDoseLevels}(x, ..., asis = TRUE)

\method{knit_print}{IncrementsHSRBeta}(x, ..., asis = TRUE)

\method{knit_print}{IncrementsMin}(x, ..., asis = TRUE)

\method{knit_print}{IncrementsOrdinal}(x, ..., asis = TRUE)

\method{knit_print}{IncrementsRelativeParts}(x, ..., asis = TRUE, tox_label = c("toxicity", "toxicities"))

\method{knit_print}{IncrementsRelativeDLTCurrent}(x, ..., asis = TRUE, tox_label = c("DLT", "DLTs"))

\method{knit_print}{NextBestMTD}(
  x,
  ...,
  target_label = "the 25th centile",
  tox_label = "toxicity",
  asis = TRUE
)

\method{knit_print}{NextBestNCRM}(x, ..., tox_label = "toxicity", asis = TRUE)

\method{knit_print}{NextBestThreePlusThree}(
  x,
  ...,
  tox_label = c("toxicity", "toxicities"),
  label = "participant",
  asis = TRUE
)

\method{knit_print}{NextBestDualEndpoint}(
  x,
  ...,
  tox_label = "toxicity",
  biomarker_label = "the biomarker",
  biomarker_units = ifelse(x@target_relative, "\%", ""),
  asis = TRUE
)

\method{knit_print}{NextBestMinDist}(x, ..., tox_label = "toxicity", asis = TRUE)

\method{knit_print}{NextBestInfTheory}(
  x,
  ...,
  tox_label = "toxicity",
  citation_text = "Mozgunov & Jaki (2019)",
  citation_link = "https://doi.org/10.1002/sim.8450",
  asis = TRUE
)

\method{knit_print}{NextBestTD}(x, ..., tox_label = "toxicity", asis = TRUE)

\method{knit_print}{NextBestMaxGain}(x, ..., tox_label = "toxicity", asis = TRUE)

\method{knit_print}{NextBestProbMTDLTE}(x, ..., tox_label = "toxicity", asis = TRUE)

\method{knit_print}{NextBestProbMTDMinDist}(x, ..., tox_label = "toxicity", asis = TRUE)

\method{knit_print}{NextBestNCRMLoss}(
  x,
  ...,
  tox_label = "toxicity",
  asis = TRUE,
  format_func = h_knit_format_func
)

\method{knit_print}{NextBestTDsamples}(x, ..., tox_label = "toxicity", asis = TRUE)

\method{knit_print}{NextBestMaxGainSamples}(x, ..., tox_label = "toxicity", asis = TRUE)

\method{knit_print}{NextBestOrdinal}(x, ..., tox_label = "toxicity", asis = TRUE)

\method{knit_print}{SafetyWindow}(x, ..., asis = TRUE, time_unit = "day", label = "participant")

\method{knit_print}{SafetyWindowConst}(
  x,
  ...,
  asis = TRUE,
  label = "participant",
  ordinals = c("first", "second", "third", "fourth", "fifth", "sixth", "seventh",
    "eighth", "ninth", "tenth"),
  time_unit = "day"
)

\method{knit_print}{SafetyWindowSize}(
  x,
  ...,
  asis = TRUE,
  ordinals = c("first", "second", "third", "fourth", "fifth", "sixth", "seventh",
    "eighth", "ninth", "tenth"),
  label = "participant",
  time_unit = "day",
  level = 2L
)

\method{knit_print}{StoppingOrdinal}(x, ..., asis = TRUE)

\method{knit_print}{StoppingMaxGainCIRatio}(x, ..., asis = TRUE)

\method{knit_print}{StoppingList}(x, ..., preamble, indent = 0L, asis = TRUE)

\method{knit_print}{StoppingAny}(x, ..., preamble, asis = TRUE)

\method{knit_print}{StoppingAll}(x, ..., preamble, asis = TRUE)

\method{knit_print}{StoppingTDCIRatio}(
  x,
  ...,
  dose_label = "the next best dose",
  tox_label = "toxicity",
  fmt_string =
    paste0("\%sIf, at \%s, the ratio of the upper to the lower limit of the posterior ",
    "95\%\% credible interval for \%s (targetting \%2.0f\%\%) is less than or equal to "),
  asis = TRUE
)

\method{knit_print}{StoppingTargetBiomarker}(
  x,
  ...,
  dose_label = "the next best dose",
  biomarker_label = "the target biomarker",
  fmt_string =
    paste0("\%sIf, at \%s, the posterior probability that \%s is in the range ",
    "(\%.2f, \%.2f)\%s is \%.0f\%\% or more.\\n\\n"),
  asis = TRUE
)

\method{knit_print}{StoppingLowestDoseHSRBeta}(
  x,
  ...,
  tox_label = "toxicity",
  fmt_string =
    paste0("\%sIf, using a Hard Stopping Rule with a prior of Beta(\%.0f, \%.0f), the ",
    "lowest dose in the dose grid has a posterior probability of \%s of ",
    "\%.0f\%\% or more.\\n\\n"),
  asis = TRUE
)

\method{knit_print}{StoppingMTDCV}(
  x,
  ...,
  fmt_string =
    paste0("\%sIf the posterior estimate of the robust coefficient of variation of ",
    "the MTD (targetting \%2.0f\%\%), is than or equal to \%.0f\%\%.\\n\\n"),
  asis = TRUE
)

\method{knit_print}{StoppingMTDdistribution}(
  x,
  ...,
  fmt_string =
    "\%sIf the mean posterior probability of \%s at \%.0f\%\% of \%s is at least \%4.2f.\\n\\n",
  dose_label = "the next best dose",
  tox_label = "toxicity",
  asis = TRUE
)

\method{knit_print}{StoppingHighestDose}(
  x,
  ...,
  dose_label = "the highest dose in the dose grid",
  asis = TRUE
)

\method{knit_print}{StoppingSpecificDose}(x, ..., dose_label = as.character(x@dose), asis = TRUE)

\method{knit_print}{StoppingTargetProb}(
  x,
  ...,
  fmt_string =
    paste0("\%sIf the probability of \%s at \%s is in the range [\%4.2f, \%4.2f] ",
    "is at least \%4.2f.\\n\\n"),
  dose_label = "the next best dose",
  tox_label = "toxicity",
  asis = TRUE
)

\method{knit_print}{StoppingMinCohorts}(x, ..., asis = TRUE)

\method{knit_print}{StoppingMinPatients}(x, ..., label = "participant", asis = TRUE)

\method{knit_print}{StoppingPatientsNearDose}(
  x,
  ...,
  dose_label = "the next best dose",
  label = "participants",
  asis = TRUE
)

\method{knit_print}{StoppingCohortsNearDose}(x, ..., dose_label = "the next best dose", asis = TRUE)

\method{knit_print}{StoppingMissingDose}(x, ..., asis = TRUE)
}
\arguments{
\item{x}{(\code{ModelParamsNormal})\cr the object to be rendered}

\item{...}{passed to \code{\link[knitr:kable]{knitr::kable()}}}

\item{asis}{(\code{flag})\cr Not used at present}

\item{label}{(\code{character})\cr the term used to label participants}

\item{tox_label}{(\code{character})\cr the term used to describe toxicity}

\item{level}{(\code{count})\cr the markdown level at which the headings for cohort size
will be printed.  An integer between 1 and 6}

\item{title}{(\code{character}) The text of the heading of the section describing
the design}

\item{sections}{(\code{character}) a named vector of length at least 4 defining
the headings used to define the sections corresponding to the design's slots.
The element names must match the Design's slot names.}

\item{full_grid}{(\code{flag})\cr Should the full dose grid appear in the output table
or simply those doses for whom at least one evaluable participant is available?
Ignored unless \code{summarise == "dose"}.}

\item{summarise}{(\code{character})\cr How to summarise the observed data.  The default,
\code{"none"}, lists observed data at the participant level.  \code{"dose"} presents
participant counts by dose and \code{"cohort"} by cohort.}

\item{summarize}{(\code{character})\cr Synonym for \code{summarise}}

\item{units}{(\code{character})\cr The units in which the values in \code{doseGrid} are}

\item{format_func}{(\code{function})\cr The function used to format the range table.}

\item{use_values}{(\code{flag})\cr print the values associated with hyperparameters,
or the symbols used to define the hyper-parameters.  That is, for example, mu or 1.}

\item{fmt}{(\code{character})\cr the \code{sprintf} format string used to render
numerical values.  Ignored if \code{use_values} is \code{FALSE}.}

\item{biomarker_label}{(\code{character})\cr the term used to describe the biomarker}

\item{params}{(\code{character})\cr The names of the model parameters.  See Usage
Notes below.}

\item{preamble}{(\code{character})\cr the text that introduces the list of rules}

\item{theta}{(\code{character})\cr the LaTeX representation of the theta vector}

\item{eff_label}{(\code{character})\cr the term used to describe efficacy}

\item{target_label}{(\code{character})\cr the term used to describe the target
toxicity rate}

\item{biomarker_units}{(\code{character})\cr the units in which the biomarker is
measured}

\item{citation_text}{(\code{character})\cr the text used to cite Mozgunov & Jaki}

\item{citation_link}{(\code{character})\cr the link to Mozgunov & Jaki}

\item{time_unit}{(\code{character})\cr the word used to describe units of time.
See Usage Notes below.}

\item{ordinals}{(\code{character})\cr a character vector whose nth defines the
word used as the written representation of the nth ordinal number.}

\item{indent}{(\code{integer})\cr the indent level of the current stopping rule
list. Spaces with length \code{indent * 4} will be prepended to the beginning of
the rendered stopping rule list.}

\item{dose_label}{(\code{character})\cr the term used to describe the target dose}

\item{fmt_string}{(\code{character})\cr the character string that defines the format
of the output}
}
\value{
a character string that represents the object in markdown.

The markdown representation of the object, as a character string

a character string that represents the object in markdown.

A character string containing a LaTeX rendition of the object.

a character string that represents the object in markdown.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

We provide additional utility functions to allow human-friendly rendition of
crmPack objects in Markdown and Quarto files

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

We provide additional utility functions to allow human-friendly rendition of
crmPack objects in Markdown and Quarto files.  This file contains methods for
all design classes, not just those that are direct descendants of \code{Design}.

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

We provide additional utility functions to allow human-friendly rendition of
crmPack objects in Markdown and Quarto files

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\section{Usage Notes}{

\code{label} describes the trial's participants.

It should be a character vector of length 1 or 2.  If of length 2, the first
element describes a \code{cohort_size} of 1 and the second describes all other
\code{cohort_size}s.  If of length 1, the character \code{s} is appended to the value
when \code{cohort_size} is not 1.


The default value of \code{col.names} is \code{c("Lower", "Upper", "Cohort size")} and
that of \code{caption} is \code{"Defined by the dose to be used in the next cohort"}.
These values can be overridden by passing \code{col.names} and \code{caption} in the
function call.


The by default, the columns are labelled \code{Lower}, \code{Upper} and \verb{Cohort size}.
The table's caption is \verb{Defined by the number of <tox_label[2]> so far observed}.
These values can be overridden by passing \code{col.names} and \code{caption} in the
function call.


\code{label} describes the trial's participants.

It should be a character vector of length 1 or 2.  If of length 2, the first
element describes a single participant and the second describes all other
situations.  If of length 1, the character \code{s} is appended to the value
when the number of participants is not 1.
The default values of \code{col.names} and \code{caption} vary depending on the summary
requested. The default values can be overridden by passing \code{col.names} and
\code{caption} in the function call.


\code{params} must be a character vector of length equal to that of \code{x@mean} (and
\code{x@cov}).  Its values represent the parameters of the model as entries in the
vector \code{theta}, on the left-hand side of "~" in the definition of the prior.
If named, names should be valid LaTeX, escaped as usual for R character variables.
For example, \code{"\\\\alpha"} or \code{"\\\\beta_0"}.  If unnamed, names are constructed by
pre-pending an escaped backslash to each value provided.


The default value of \code{col.names} is \code{c("Min", "Max", "Increment")} and that
of \code{caption} is \code{"Defined by highest dose administered so far"}.  These
values can be overridden by passing \code{col.names} and \code{caption} in the function
call.


The default value of \code{col.names} is \code{c("Min", "Max", "Increment")} and that
of \code{caption} is \code{"Defined by number of DLTs reported so far"}. These values
can be overridden by passing \code{col.names} and \code{caption} in the function call.


\code{label} defines how toxicities are described.

It should be a character vector of length 1 or 2.  If of length 2, the first
element describes a single toxicity and the second describes all other
toxicity counts.  If of length 1, the character \code{s} is appended to the value
describing a single toxicity.


The default value of \code{col.names} is \code{c("Min", "Max", "Increment")} and that
of \code{caption} is \code{"Defined by number of DLTs in the current cohort"}. These values
can be overridden by passing \code{col.names} and \code{caption} in the function call.

\code{tox_label} defines how toxicities are described.

It should be a character vector of length 1 or 2.  If of length 2, the first
element describes a single toxicity and the second describes all other
toxicity counts.  If of length 1, the character \code{s} is appended to the value
describing a single toxicity.


This section describes the use of \code{label} and \code{tox_label}, collectively
referred to as \code{label}s.
A \code{label} should be a scalar or a vector of length 2.  If a scalar, it is
converted by adding a second element that is equal to the first, suffixed by \code{s}.
For example, \code{tox_label = "DLT"} becomes \code{tox_label = c("DLT", "DLTs")}.  The
first element of the vector is used to describe a count of 1.  The second
is used in all other cases.


To use a BibTeX-style citation, specify (for example) \verb{citation_text = "@MOZGUNOV", citation_link = ""}.


\code{label} should be a character vector of length 1 or 2.  If of length 2, the first
element describes a count of 1 and the second describes all other counts.
If of length 1, the character \code{s} is appended to the value when the count is not 1.


\code{label} and \code{time_unit} are, collectively, labels.

A label should be a character vector of length 1 or 2.  If of length 2, the first
element describes a count of 1 and the second describes all other counts.
If of length 1, the character \code{s} is appended to the value when the count is not 1.


\code{label} describes the trial's participants.

It should be a character vector of length 1 or 2.  If of length 2, the first
element describes a \code{cohort_size} of 1 and the second describes all other
\code{cohort_size}s.  If of length 1, the character \code{s} is appended to the value
when \code{cohort_size} is not 1.


The default value of \code{col.names} is \code{c("Lower", "Upper", "Cohort size")} and
that of \code{caption} is \code{"Defined by the dose to be used in the next cohort"}.
These values can be overridden by passing \code{col.names} and \code{caption} in the
function call.


The by default, the columns are labelled \code{Lower}, \code{Upper} and \verb{Cohort size}.
The table's caption is \verb{Defined by the number of <tox_label[2]> so far observed}.
These values can be overridden by passing \code{col.names} and \code{caption} in the
function call.


\code{label} describes the trial's participants.

It should be a character vector of length 1 or 2.  If of length 2, the first
element describes a single participant and the second describes all other
situations.  If of length 1, the character \code{s} is appended to the value
when the number of participants is not 1.
The default values of \code{col.names} and \code{caption} vary depending on the summary
requested. The default values can be overridden by passing \code{col.names} and
\code{caption} in the function call.


\code{params} must be a character vector of length equal to that of \code{x@mean} (and
\code{x@cov}).  Its values represent the parameters of the model as entries in the
vector \code{theta}, on the left-hand side of "~" in the definition of the prior.
If named, names should be valid LaTeX, escaped as usual for R character variables.
For example, \code{"\\\\alpha"} or \code{"\\\\beta_0"}.  If unnamed, names are constructed by
pre-pending an escaped backslash to each value provided.


The default value of \code{col.names} is \code{c("Min", "Max", "Increment")} and that
of \code{caption} is \code{"Defined by highest dose administered so far"}.  These
values can be overridden by passing \code{col.names} and \code{caption} in the function
call.


The default value of \code{col.names} is \code{c("Min", "Max", "Increment")} and that
of \code{caption} is \code{"Defined by number of DLTs reported so far"}. These values
can be overridden by passing \code{col.names} and \code{caption} in the function call.


\code{label} defines how toxicities are described.

It should be a character vector of length 1 or 2.  If of length 2, the first
element describes a single toxicity and the second describes all other
toxicity counts.  If of length 1, the character \code{s} is appended to the value
describing a single toxicity.


The default value of \code{col.names} is \code{c("Min", "Max", "Increment")} and that
of \code{caption} is \code{"Defined by number of DLTs in the current cohort"}. These values
can be overridden by passing \code{col.names} and \code{caption} in the function call.

\code{tox_label} defines how toxicities are described.

It should be a character vector of length 1 or 2.  If of length 2, the first
element describes a single toxicity and the second describes all other
toxicity counts.  If of length 1, the character \code{s} is appended to the value
describing a single toxicity.


This section describes the use of \code{label} and \code{tox_label}, collectively
referred to as \code{label}s.
A \code{label} should be a scalar or a vector of length 2.  If a scalar, it is
converted by adding a second element that is equal to the first, suffixed by \code{s}.
For example, \code{tox_label = "DLT"} becomes \code{tox_label = c("DLT", "DLTs")}.  The
first element of the vector is used to describe a count of 1.  The second
is used in all other cases.


To use a BibTeX-style citation, specify (for example) \verb{citation_text = "@MOZGUNOV", citation_link = ""}.


\code{label} should be a character vector of length 1 or 2.  If of length 2, the first
element describes a count of 1 and the second describes all other counts.
If of length 1, the character \code{s} is appended to the value when the count is not 1.


\code{label} and \code{time_unit} are, collectively, labels.

A label should be a character vector of length 1 or 2.  If of length 2, the first
element describes a count of 1 and the second describes all other counts.
If of length 1, the character \code{s} is appended to the value when the count is not 1.
}

\seealso{
\code{\link{knit_print}} for more details.
}
