% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coinmarketcap.R
\name{coinmarketcap_api_call}
\alias{coinmarketcap_api_call}
\title{coinmarketcap_api_call}
\usage{
coinmarketcap_api_call(
  url,
  api_key,
  method,
  query = NULL,
  timeout_seconds = 60
)
}
\arguments{
\item{url}{the url for your CoinMarketCap API call}

\item{api_key}{your CoinMarketCap API key}

\item{method}{"GET" or "POST"}

\item{query}{your query parameters. The default value is NULL.}

\item{timeout_seconds}{seconds until the query times out. Default is 60.}
}
\value{
returns data from your CoinMarketCap API call
}
\description{
coinmarketcap_api_call
}
\examples{
\dontrun{
url <- "https://pro-api.coinmarketcap.com/v1/cryptocurrency/map"
api_key <- "..."
query_string <- list(
  listing_status = "active",
  start = "1",
  limit = NULL,
  sort = "id",
  symbol = NULL,
  aux = "platform,first_historical_data,last_historical_data,is_active,status"
)
data <- coinmarketcap_api_call(url, api_key, 'GET', query = query_string)}
}
