% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dists.R
\name{wrap.meaningdistfunction}
\alias{wrap.meaningdistfunction}
\title{Make a meaning distance function vectorisable.}
\usage{
wrap.meaningdistfunction(pairwisemeaningdistfun)
}
\arguments{
\item{pairwisemeaningdistfun}{a function of two arguments returning a
single numeric indicating the semantic distance between its arguments}
}
\value{
A function that takes a meaning matrix and returns a corresponding
distance matrix of class \code{\link[stats]{dist}}.
}
\description{
This function takes as its only argument a function \code{f(m1, m2)} which
returns a single numeric indicating the distance between two 'meanings'
\code{m1, m2} (which are themselves most likely vectors or lists). Based
on \code{f}, this function returns a function \code{g(mm)} which takes as
its only argument a matrix or data frame \code{mm} with the meaning
elements (equivalent to the ones in \code{m1, m2}) along columns and
different meaning combinations (like \code{m1, m2, ...}) along rows. This
function returns a distance matrix of class \code{\link[stats]{dist}}
containing all pairwise distances between the rows of \code{mm}. The
resulting function \code{g} can be passed to other functions in this
package, in particular \code{\link{mantel.test}}.
}
\details{
The meaning distance function should be commutative, i.e.
\code{f(a,b) = f(b,a)}, and meanings should have a distance of zero to
themselves, i.e. \code{f(a,a) = 0}.
}
\examples{
trivialdistance <- function(a, b) return(a - b)

trivialmeanings <- as.matrix(3:1)
trivialdistance(trivialmeanings[1], trivialmeanings[2])
trivialdistance(trivialmeanings[1], trivialmeanings[3])
trivialdistance(trivialmeanings[2], trivialmeanings[3])

distmatrixfunction <- wrap.meaningdistfunction(trivialdistance)
distmatrixfunction(trivialmeanings)
}
