% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{trade}
\alias{trade}
\title{World Trade 2019 and 2023}
\format{
A data frame with 5,223 observations and 8 variables.
}
\source{
Derived from the UN Comtrade database (\url{https://comtrade.un.org/}).
}
\usage{
trade
}
\description{
Bilateral trade flows between countries for the years 2019 and 2023.
Trade values are expressed in USD billion dollars.
}
\section{Variables}{

\itemize{
\item \code{year}: Year of the trade data (2019 or 2023).
\item \code{reporter_continent}: Continent of the reporting country.
\item \code{partner_continent}: Continent of the partner country.
\item \code{reporter}: Name of the reporting country.
\item \code{partner}: Name of the partner country.
\item \code{reporter_iso}: ISO 3166-1 alpha-3 code of the reporting country.
\item \code{partner_iso}: ISO 3166-1 alpha-3 code of the partner country.
\item \code{trade}: Trade value in USD billion dollars. Reporter (importer-side) figures are used.
}
}

\examples{
head(trade[trade$year == 2023L & trade$reporter_iso == "gbr", ])
}
\keyword{datasets}
