% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manipulate.R
\name{build_token_df}
\alias{build_token_df}
\title{Build token dataframe}
\usage{
build_token_df(object, type = "sync")
}
\arguments{
\item{object}{either a HTTP response object from
\code{dai_sync()} or the path to a JSON file from
\code{dai_async()}.}

\item{type}{one of "sync" or "async" depending on
the function used to process the original document.}
}
\value{
a token data frame
}
\description{
Builds a token dataframe from the text OCRed by
Document AI (DAI) in an asynchronous request. Rows are tokens, in the
order DAI proposes to read them. Columns are location variables
such as page coordinates and block bounding box numbers.
}
\details{
The location variables are: token, start index, end index,
confidence, left boundary, right boundary, top boundary, bottom boundary,
page number, and block number. Start and end indices refer to
character position in the string containing the full text.
}
\examples{
\dontrun{
resp <- dai_sync("file.pdf")
token_df <- build_token_df(resp)

token_df <- build_token_df("pdf_output.json", type = "async")
}
}
