% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discrete_laplace.R
\name{ddlaplace}
\alias{ddlaplace}
\alias{rdlaplace}
\title{Discrete Laplace Distribution}
\usage{
ddlaplace(x, scale = 1, log = FALSE)

rdlaplace(n, scale = 1)
}
\arguments{
\item{x}{a vector of quantiles.}

\item{scale}{the scale parameter.}

\item{log}{logical; if \code{TRUE}, probabilities are given as log(p).}

\item{n}{number of random deviates.}
}
\value{
\itemize{
\item ddlaplace() returns a numeric vector representing the probability mass function of the
discrete Laplace distribution.
\item rdlaplace() returns a numeric vector of random samples from the discrete Laplace distribution.
}
}
\description{
The probability mass function and random number generator for the
discrete Laplacian distribution.
}
\details{
Probability mass function
\deqn{
P[X=x] = \dfrac{e^{1/t} - 1}{e^{1/t} + 1} e^{-|x|/t}.
}
}
\examples{
# mass function
ddlaplace(0)

# mass function is vectorized
ddlaplace(0:10, scale = 5)

# generate random samples
rdlaplace(10)

}
\references{
Canonne, C. L., Kamath, G., & Steinke, T. (2020). The Discrete Gaussian for Differential Privacy.
\emph{arXiv}. \doi{https://doi.org/10.48550/ARXIV.2004.00010}
}
