% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-forecast-for.r
\name{get_forecast_for}
\alias{get_forecast_for}
\title{Retrieve weather data for a specific place/time}
\usage{
get_forecast_for(latitude, longitude, timestamp, units = "us",
  language = "en", exclude = NULL, add_json = FALSE,
  add_headers = FALSE, ...)
}
\arguments{
\item{latitude}{forecast latitude (character, decimal format)}

\item{longitude}{forecast longitude (character, decimal format)}

\item{timestamp}{should either be a UNIX time (that is, seconds since midnight GMT on 1
Jan 1970) or a string formatted as follows: \code{[YYYY]-[MM]-[DD]T[HH]:[MM]:[SS]}
(with an optional time zone formatted as \code{Z} for GMT time or
\code{[+|-][HH][MM]} for an offset in hours or minutes). For the latter format, if no
timezone is present, local time (at the provided latitude and longitude) is assumed.
(This string format is a subset of ISO 8601 time. An as example,
\code{2013-05-06T12:00:00-0400}.) If an R \code{Date} or \code{POSIXct} object is passed in
it will be converted into the proper format.}

\item{units}{return the API response in units other than the default Imperial unit}

\item{language}{return text summaries in the desired language}

\item{exclude}{exclude some number of data blocks from the API response. This is useful
for reducing latency and saving cache space. This should be a comma-separated string
(without spaces) including one or more of the following: (\code{currently},
\code{minutely}, \code{hourly}, \code{daily}, \code{alerts}, \code{flags}). Crafting
a request with all of the above blocks excluded is exceedingly silly and not
recommended. Setting this parameter to \code{NULL} (the default) does not exclude any
parameters from the results.}

\item{add_json}{add the raw JSON response to the object?}

\item{add_headers}{add the return headers to the object?}

\item{...}{pass through parameters to \code{httr::GET} (e.g. to configure ssl options
or proxies)}
}
\value{
an \code{darksky} object that contains the original JSON response object (optionally), a
list of  named \code{tbl_df} \code{data.frame} objects corresponding to what was returned by
the API and (optionally) relevant response headers (\code{cache-control}, \code{expires},
\code{x-forecast-api-calls}, \code{x-response-time}).
}
\description{
Query for a specific time, past or future (for many places, 60 years in the past to 10
years in the future).
}
\details{
If you wish to have results in something besides Imperial units, set \code{units} to
one of (\code{si}, \code{ca}, \code{uk}). Setting \code{units} to \code{auto} will have
the API select the relevant units automatically, based on geographic location. This
value is set to \code{us} (Imperial) units by default.

If you wish to have text summaries presented in a different language, set
\code{language} to one of (\code{ar}, \code{bs}, \code{de}, \code{es}, \code{fr},
\code{it}, \code{nl}, \code{pl}, \code{pt}, \code{ru}, \code{sv}, \code{tet},
\code{tr}, \code{x-pig-latin}, \code{zh}). This value is set to \code{en} (English) by
default.

See the Options section of the official
\href{https://darksky.net/dev/docs}{Dark Sky API documentation} for more
information.
}
\examples{
\dontrun{
tmp <- get_forecast_for(37.8267,-122.423, "2013-05-06T12:00:00-0400")
}
}
