% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.sim.WF.run.r
\name{gl.sim.WF.run}
\alias{gl.sim.WF.run}
\title{Runs Wright-Fisher simulations}
\usage{
gl.sim.WF.run(
  file_var,
  ref_table,
  x = NULL,
  file_dispersal = NULL,
  number_iterations = 1,
  every_gen = 10,
  sample_percent = 50,
  store_phase1 = FALSE,
  interactive_vars = TRUE,
  seed = NULL,
  verbose = NULL,
  ...
)
}
\arguments{
\item{file_var}{Path of the variables file 'sim_variables.csv' (see details) 
[required if interactive_vars = FALSE].}

\item{ref_table}{Reference table created by the function 
\code{\link{gl.sim.WF.table}} [required].}

\item{x}{Name of the genlight object containing the SNP data to extract
values for some simulation variables (see details) [default NULL].}

\item{file_dispersal}{Path of the file with the dispersal table created with
the function \code{\link{gl.sim.create_dispersal}} [default NULL].}

\item{number_iterations}{Number of iterations of the simulations [default 1].}

\item{every_gen}{Generation interval at which simulations should be stored in
a genlight object [default 10].}

\item{sample_percent}{Percentage of individuals, from the total population, 
to sample and save in the genlight object every generation [default 50].}

\item{store_phase1}{Whether to store simulations of phase 1 in genlight
objects [default FALSE].}

\item{interactive_vars}{Run a shiny app to input interactively the values of
simulations variables [default TRUE].}

\item{seed}{Set the seed for the simulations [default NULL].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report
[default 2, unless specified using gl.set.verbosity].}

\item{...}{Any variable and its value can be added separately within the 
function, will be changed over the input value supplied by the csv file. See 
tutorial.}
}
\value{
Returns genlight objects with simulated data.
}
\description{
This function simulates populations made up of diploid organisms that 
reproduce in non-overlapping generations. Each individual has a pair of 
homologous chromosomes that contains interspersed selected and neutral loci. 
For the initial generation, the genotype for each individual’s chromosomes is
randomly drawn from distributions at linkage equilibrium and in 
Hardy-Weinberg equilibrium. 

See documentation and tutorial for a complete description of the simulations.
These documents can be accessed at 
https://github.com/green-striped-gecko/dartR/wiki/Simulations-tutorial

Take into account that the simulations will take a little longer the
first time you use the function gl.sim.WF.run() because C++ functions must
be compiled.
}
\examples{
ref_table <- gl.sim.WF.table(file_var=system.file("extdata", 
"ref_variables.csv", package = "dartR.sim"),interactive_vars = FALSE)

res_sim <- gl.sim.WF.run(file_var = system.file("extdata",
 "sim_variables.csv", package ="dartR.sim"),ref_table=ref_table,
 interactive_vars = FALSE)
}
\seealso{
\code{\link{gl.sim.WF.table}}

Other simulation functions: 
\code{\link{gl.sim.WF.table}()},
\code{\link{gl.sim.create_dispersal}()}
}
\author{
Custodian: Luis Mijangos
}
\concept{simulation functions}
