% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_waterdata_metadata.R
\name{read_waterdata_metadata}
\alias{read_waterdata_metadata}
\title{Generalized USGS Water Meta Data API retrieval function}
\usage{
read_waterdata_metadata(collection, max_results = NA, limit = NA)
}
\arguments{
\item{collection}{character, can be any existing collection such
as "parameter-codes", "agency-codes", "altitude-datums", "aquifer-codes",
"aquifer-types", "coordinate-accuracy-codes", "coordinate-datum-codes",
"coordinate-method-codes", "hydrologic-unit-codes", "medium-codes",
"national-aquifer-codes", "reliability-codes", "site-types", "statistic-codes",
"topographic-codes", "time-zone-codes".}

\item{max_results}{The optional maximum number of rows to return. This value
must be less than the requested limit.}

\item{limit}{The optional limit parameter is used to control the subset of the
selected features that should be returned in each page. The maximum allowable
limit is 10000. It may be beneficial to set this number lower if your internet
connection is spotty. The default (\code{NA}) will set the limit to the maximum
allowable limit for the service.}
}
\description{
Function to get metadata from Water Data API. These are useful to get the
human readable words and other metadata associated with USGS codes.
}
\examples{
\dontshow{if (is_dataRetrieval_user()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

\donttest{
agency_codes <- read_waterdata_metadata("agency-codes")
altitude_datums <- read_waterdata_metadata("altitude-datums")
aquifer_codes <- read_waterdata_metadata("aquifer-codes")
aquifer_types <- read_waterdata_metadata("aquifer-types")
coordinate_accuracy_codes <- read_waterdata_metadata("coordinate-accuracy-codes")
coordinate_datum_codes <- read_waterdata_metadata("coordinate-datum-codes")
coordinate_method_codes <- read_waterdata_metadata("coordinate-method-codes")
huc_codes <- read_waterdata_metadata("hydrologic-unit-codes")
national_aquifer_codes <- read_waterdata_metadata("national-aquifer-codes")
parameter_codes <- read_waterdata_metadata("parameter-codes")
reliability_codes <- read_waterdata_metadata("reliability-codes")
site_types <- read_waterdata_metadata("site-types")
statistic_codes <- read_waterdata_metadata("statistic-codes")
topographic_codes <- read_waterdata_metadata("topographic-codes")
time_zone_codes <- read_waterdata_metadata("time-zone-codes")
}
\dontshow{\}) # examplesIf}
}
