% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/K9_events.R
\name{k9_get_events}
\alias{k9_get_events}
\title{Get Events}
\usage{
k9_get_events(event_id = NULL, start = NULL, end = NULL,
  priority = NULL, sources = NULL, tags = NULL, .split_request = TRUE)
}
\arguments{
\item{event_id}{Event ID.}

\item{start}{POSIX timestamp.}

\item{end}{POSIX timestamp.}

\item{priority}{Priority of events. \code{NULL}, \code{"low"} or \code{"normal"}.}

\item{sources}{Sources of events. A \code{character} vector or a single comma-separated \code{character}.}

\item{tags}{Tags of events. A named \code{list} or a single comma-separated \code{character}.}

\item{.split_request}{if \code{TRUE}, automatically split the request when the target period is longer than a day}
}
\description{
This end point allows you to query for event details.
}
\examples{
\dontrun{
# by default get all events happend from an hour ago
k9_get_events()

# get all events happend in this week
k9_get_events(start = Sys.Date() - 7, end = Sys.Date())

# specify an event by ID
k9_get_events(event_id = "112233445566")

# specify tag
k9_get_events(tags = list(role = "db"))
}

}
\seealso{
\url{http://docs.datadoghq.com/api/?lang=console#events}
}
