% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dp_get_data.R
\name{dp_get_data}
\alias{dp_get_data}
\alias{dp_get_data.dataresource}
\alias{dp_get_data.datapackage}
\title{Get the data belonging to a Data Resource}
\usage{
dp_get_data(x, ..., as_connection = FALSE)

\method{dp_get_data}{dataresource}(x, reader = "guess", ..., as_connection = FALSE)

\method{dp_get_data}{datapackage}(x, resource_name, reader = "guess", ..., as_connection = FALSE)
}
\arguments{
\item{x}{a \code{dataresource} or \code{datapackage} object.}

\item{...}{passed on to the \code{reader}}

\item{as_connection}{Try to return a connection to the data instead of the
data itself. When a reader does not support returning connections it will
return the data.}

\item{reader}{the reader to use to read the data. This should be either a
function accepting the path to the data set (a character vector with possibly
multitple filenames) and the Data Resource as second argument, or the
character string \code{"guess"}.}

\item{resource_name}{the name of the \code{dataresource}.}
}
\value{
Will return the data. This will generally be a \code{data.frame} but
depending on the file type can also be other types of R-objects. 

When called with the \code{as_connection = TRUE} argument, it will try to
return a connection to the data. This depends on the reader. When the reader
does not support returning connections it will return the data.
}
\description{
Get the data belonging to a Data Resource
}
\details{
When \code{reader = "guess"} the function will try to guess which reader to
use based on the \code{format} and \code{mediatype} of the Data Resource.
Currently only CSV is supported. For other data types a custom reader has to
be provided unless the data is stored inside the Data Resource object.

It is also possible to assign default readers for data formats. For that see
\code{\link{dp_add_reader}}.
}
\seealso{
\code{dp_get_connection} is a wrapper around 
\code{dp_get_data(..., as_connection = TRUE)}.
}
