% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projectToeplitz.R
\name{projectToeplitz}
\alias{projectToeplitz}
\title{Projection onto the set of symmetric Toeplitz matrices}
\usage{
projectToeplitz(matrix)
}
\arguments{
\item{matrix}{a symmetric matrix.}
}
\value{
The computed projection matrix.
}
\description{
Computes the orthogonal projection onto the space of symmetric Toeplitz 
matrices as given in \cite{Grigoriadis et al. (1994)}.
}
\examples{
 
A <- matrix(c(2, 1, 1, 1, 2, 0, 1, 0, 0), byrow = 3, nrow = 3)
projectToeplitz(A)
 
}
\references{
Grigoriadis, K.M., Frazho, A., Skelton, R. (1994). 
\emph{Application of alternating convex projection methods for computation 
of positive Toeplitz matrices}, IEEE Transactions on signal processing 
\bold{42(7)}, 1873--1875
}
\seealso{
\code{\link{nearPDToeplitz}}
}
