% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbglm.R
\name{dbglm}
\alias{dbglm}
\alias{dbsample}
\title{Fast generalized linear model in a database}
\usage{
dbglm(formula, family = binomial(), tbl, sd = FALSE,
weights = .NotYetImplemented(), subset = .NotYetImplemented(), ...)
}
\arguments{
\item{...}{This argument is required for S3 method extension.}

\item{formula}{A model formula. It can have interactions but cannot have any transformations except \code{factor}}

\item{family}{Model family}

\item{tbl}{An object inheriting from \code{tbl}. Will typically be a database-backed lazy \code{tbl} from the \code{dbplyr} package.}

\item{sd}{Experimental: compute the standard deviation of the score as well as the mean in the update and use it to improve the information matrix estimate}

\item{weights}{We don't support weights}

\item{subset}{If you want to analyze a subset, use \code{filter()} on the data}
}
\value{
A list with elements \item{tildebeta }{coefficients from subsample} \item{hatbeta }{final estimate} \item{tildeV }{variance matrix from subsample} \item{hatV }{final estimate}
}
\description{
Fast generalized linear model in a database
}
\details{
For a dataset of size \code{N} the subsample is of size \code{N^(5/9)}. Unless \code{N} is large the approximation won't be very good. Also, with small \code{N} it's quite likely that, eg, some factor levels will be missing in the subsample.
}
\references{
\url{http://notstatschat.tumblr.com/post/171570186286/faster-generalised-linear-models-in-largeish-data}
}
