% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p.dcsvm.R
\name{predict.dcsvm}
\alias{predict.dcsvm}
\title{Make Predictions for Sparse Density-Convoluted SVM}
\usage{
\method{predict}{dcsvm}(object, newx, s = NULL, type = c("class", "link"), ...)
}
\arguments{
\item{object}{A fitted \code{\link{dcsvm}} object.}

\item{newx}{A matrix of new values for \code{x} at which predictions are to be made. Note that \code{newx} must be a matrix; vectors or other formats are not accepted.}

\item{s}{Value(s) of the L1 tuning parameter \code{lambda} for computing coefficients. Default is the entire \code{lambda} sequence obtained by \code{\link{dcsvm}}.}

\item{type}{\code{"class"} or \code{"link"}? \code{"class"} produces the predicted binary class labels, while \code{"link"} returns the fitted values. Default is \code{"class"}.}

\item{...}{Not used. Other arguments to \code{predict}.}
}
\value{
Returns either the predicted class labels or the fitted values, depending on the choice of \code{type}.
}
\description{
Predicts binary class labels or fitted values for a \code{dcsvm} model using new data.
}
\details{
Make Predictions for Sparse Density-Convoluted SVM

This function predicts the binary class labels or the fitted values of a \code{\link{dcsvm}} object.


\code{s} represents the new \code{lambda} values for making predictions. If \code{s} is not part of the original \code{lambda} sequence generated by \code{\link{dcsvm}}, \code{predict.dcsvm} uses linear interpolation to compute predictions by combining adjacent \code{lambda} values in the original sequence. This functionality is adapted from the \code{predict} methods in the \code{glmnet} and \code{gcdnet} packages.
}
\examples{
data(colon)
fit <- dcsvm(colon$x, colon$y, lam2=1)
print(predict(fit, type="class", newx=colon$x[2:5, ]))

}
\seealso{
\code{\link{coef.dcsvm}}
}
