#' @importFrom Rlibeemd emd_num_imfs ceemdan
#' @importFrom forecast auto.arima
#' @importFrom utils head tail
#' @importFrom graphics plot
#' @importFrom stats as.ts ts
#' @export
#'


ceemdanARIMA <-function (data, stepahead = 10, num.IMFs = emd_num_imfs(length(data)),
                         s.num = 4L, num.sift = 50L, ensem.size = 250L, noise.st = 0.2)
{
  n.IMF <- num.IMFs
  AllIMF <- ceemdan(ts(data), num_imfs = n.IMF, ensemble_size = ensem.size,
                    noise_strength = noise.st, S_number = s.num, num_siftings = num.sift,
                    rng_seed = 0L, threads = 0L)
  data_trn <- ts(head(data, round(length(data) - stepahead)))
  data_test <- ts(tail(data, stepahead))
  IMF_trn <- AllIMF[-c(((length(data) - stepahead) + 1):length(data)),
  ]
  Fcast_AllIMF <- NULL
  for (IMF in 1:ncol(IMF_trn)) {
    IndIMF <- NULL
    IndIMF <- IMF_trn[, IMF]
    ceemdanARIMAFit <- forecast::auto.arima(as.ts(IndIMF))
    ceemdanARIMA_fcast = forecast::forecast(ceemdanARIMAFit,
                                            h = stepahead)
    ceemdanARIMA_fcast_Mean = ceemdanARIMA_fcast$mean
    Fcast_AllIMF <- cbind(Fcast_AllIMF, as.matrix(ceemdanARIMA_fcast_Mean))
  }
  FinalceemdanARIMA_fcast <- ts(rowSums(Fcast_AllIMF, na.rm = T))
  MAE_ceemdanARIMA = mean(abs(data_test - FinalceemdanARIMA_fcast))
  MAPE_ceemdanARIMA = mean(abs(data_test - FinalceemdanARIMA_fcast)/data_test)
  RMSE_ceemdanARIMA = sqrt(mean((data_test - FinalceemdanARIMA_fcast)^2))
  Plot_IMFs <- AllIMF
  AllIMF_plots <- plot(Plot_IMFs)
  return(list(TotalIMF = n.IMF, AllIMF = AllIMF, AllIMF_plots = AllIMF_plots, data_test = data_test, AllIMF_forecast = Fcast_AllIMF,
              FinalceemdanARIMA_forecast = FinalceemdanARIMA_fcast,
              MAE_ceemdanARIMA = MAE_ceemdanARIMA, MAPE_ceemdanARIMA = MAPE_ceemdanARIMA,
              RMSE_ceemdanARIMA = RMSE_ceemdanARIMA))
}
