% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decp.R
\name{decp}
\alias{decp}
\title{Detect and Estimate Change Points}
\usage{
decp(
  input_data,
  alpha = 0.05,
  num_simulations = 10000,
  num_iterations = 100,
  verbose = TRUE
)
}
\arguments{
\item{input_data}{A numeric matrix of observations for multivariate time series
data where the dimension is not greater than the observations. Date columns should not be inputted.}

\item{alpha}{Level of significance for calculating the confidence intervals}

\item{num_simulations}{Specifies the number of simulations to be conducted during the estimation process.
It is recommended to set num_simulations to a large value to ensure greater certainty and reliability of the results.
A higher number of simulations helps in capturing the variability and improves the accuracy of the estimation.}

\item{num_iterations}{Determines the size of the two-sided random walk in the estimation process (each path).
If the jump size of the change point is small, num_iterations should be set to higher values to achieve accurate results.
For jump size >= 1, the default value is 100.}

\item{verbose}{Logical value indicating whether to print messages during the function execution. Default is TRUE.}
}
\value{
An object of class 'decp_result' containing the ordered change points, the summary of the jump sizes for each pair of segments,
the Confidence Interval (C.I.) of each detected change point, the maximum zhta, confidence interval level, and warnings in case that the C.I. of two adjacent change points overlap.
}
\description{
Detect and estimate change points.
}
\examples{
# Example usage
data_part1 <- matrix(rnorm(1500, mean = 0, sd = 1), ncol = 5)
data_part2 <- matrix(rnorm(1500, mean = 3, sd = 1), ncol = 5)
data <- rbind(data_part1, data_part2)
result <- decp(data, alpha = 0.05, num_simulations = 100, num_iterations = 50)
print(result)
}
