% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dep_map_breaks.R
\name{dep_map_breaks}
\alias{dep_map_breaks}
\title{Calculating Map Breaks}
\usage{
dep_map_breaks(.data, var, new_var, classes, style, breaks,
    sig_digits = 2, return = "col", show_warnings = TRUE)
}
\arguments{
\item{.data}{A data object, either sf, tibble, or data.frame}

\item{var}{Variable breaks should be based on, can be quoted or unquoted}

\item{new_var}{Optional name of new variable to store breaks in, can be quoted
or unquoted. This is required if you are returning a column, but can be
omitted if you are returning breaks instead of a column.}

\item{classes}{Optional integer scalar; count of the number of classes to create.
If you are supplying breaks manually, this can be omitted.}

\item{style}{String scalar; one of the classes supported by \code{classInt::classIntervals()}.
"jenks" is the ArcGIS default. "quantile" and "fisher" are better
alternatives. As with \code{classes}, this can be omitted if you are
supplying breaks manually.}

\item{breaks}{Optional numeric vector if you want to pre-specify the cut
points for your breaks. Provide the lower and upper bounds of your
distribution. Any values supplied in between the bounds will be the
upper bound of individual bins.}

\item{sig_digits}{Integer; how many significant digits should be applied when
calculating breaks and constructing labels?}

\item{return}{String scalar; one of either \code{"col"} (default) or
\code{"breaks"}. The default behavior adds a factor containing the bins
to the data object to facilitate mapping. Specifying \code{"breaks"}
will return the calculated breaks instead, which can be modified and
passed to the \code{breaks} argument later in a script to make the
final map.}

\item{show_warnings}{Logical scalar; if \code{TRUE}, warnings created by
\code{classInt::classIntervals()} if \code{NA} values are identified while
findings classes.}
}
\value{
Either a data object (if \code{return} is \code{"col"}) or a vector
    of breaks (if \code{return} is \code{"breaks"}). If a data object is
    returned, the new column will be placed directly after the input variable
    specified in \code{var}.
}
\description{
Create "bins" for choropleth maps creating using either
    \code{ggplot2} or \code{leaflet}. The function can create the bins
    automatically or will accept pre-specified breaks.
}
\examples{
# prep data
## load sample data
ndi_m <- dep_sample_data(index = "ndi_m")

## calculate NDI with sample data
ndi_m <- dep_calc_index(ndi_m, geography = "county", index = "ndi_m", year = 2022,
  return_percentiles = TRUE)

# calculate breaks using a built-in algorithm
dep_map_breaks(ndi_m, var = "NDI_M", new_var = "map_breaks", classes = 5,
  style = "fisher")

# use manually specified breaks
## set breaks
breaks <- c(0, 25, 50, 75, max(ndi_m$NDI_M))

## calculate breaks
dep_map_breaks(ndi_m, var = "NDI_M", new_var = "map_breaks", breaks = breaks)

}
