% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\name{factor.design}
\alias{factor.design}
\title{Factorial Designs}
\usage{
factor.design(...)
}
\arguments{
\item{...}{Factors to add to the design.}
}
\value{
An instance of \code{factorDesign} with the complete factorial design and all fixed and random factors.
}
\description{
The main function of this package is to create factorial designs with this function.
}
\examples{
# To create an empty design:
design <- factor.design()

# To create a design for a recognition memory experiment in
# which each participant only sees either picture or words:
design <- factor.design(
    fixed.factor("type",levels=c("pic","word")), 
    fixed.factor("status",levels=c("old","new")), 
    random.factor("subject", groups="type"), 
    random.factor("item", groups="type"), 
    random.factor(c("subject","item"), groups="status")
)

# This is identical to:
design <- fixed.factor("type",levels=c("pic","word")) + 
          fixed.factor("status",levels=c("old","new")) + 
          random.factor("subject", groups="type") + 
          random.factor("item", groups="type") + 
          random.factor(c("subject","item"), groups="status")

# Or:
design <- factor.design(
   ~type(pic,word)+status(old,new)+subject[type]+item[type]+subject:item[status]
)

# You can also create a new design by adding more factors to an existing one:

design1 <- factor.design(~type(pic,word)+status(old,new)+subject[type]+item[type])
design2 <- design1 + random.factor(c("subject","item"), groups="status")

}
\seealso{
\code{\link[designr]{random.factor}} and \code{\link[designr]{fixed.factor}} for creating factors to add to the design. \code{\link[designr]{output.design}} and \code{\link[designr]{write.design}} for creating a useful summary and writing it into output files.
}
