# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

fast_factor <- function(x) {
    .Call('_detectRUNS_fast_factor', PACKAGE = 'detectRUNS', x)
}

#' Convert 0/1/2 genotypes to 0/1
#'
#' This is a utility function, that convert 0/1/2 genotypes (AA/AB/BB) into 0/1
#' (either homozygous/heterozygous)
#'
#' @param genotype vector of 0/1/2 genotypes
#'
#' @return converted vector of genotypes (0/1)
#'
#' @useDynLib detectRUNS
#' @importFrom Rcpp sourceCpp
#'
genoConvertCpp <- function(genotype) {
    .Call('_detectRUNS_genoConvertCpp', PACKAGE = 'detectRUNS', genotype)
}

#' Convert ped genotypes to 0/1
#'
#' This is a utility function, that convert ped genotypes (AA/AB/BB) into 0/1
#' (either homozygous/heterozygous)
#'
#' @param genotype vector of pair of genotypes (01, AA, AG)
#'
#' @return converted vector of genotypes (0/1)
#'
#' @useDynLib detectRUNS
#' @importFrom Rcpp sourceCpp
#'
pedConvertCpp <- function(genotype) {
    .Call('_detectRUNS_pedConvertCpp', PACKAGE = 'detectRUNS', genotype)
}

#' Function to check whether a window is (loosely) homozygous or not
#'
#' This is a core function. Parameters on how to consider a window homozygous are here (maxHet, maxMiss)
#'
#' @param x vector of 0/1 genotypes (from genoConvert())
#' @param gaps vector of differences between consecutive positions (gaps) in bps
#' @param maxHet max n. of heterozygous SNP in a homozygous window
#' @param maxMiss max n. of missing in a window
#' @param maxGap max distance between consecutive SNP in a window to be still considered a potential run
#'
#' @return TRUE/FALSE (whether a window is homozygous or NOT)
#'
#' @useDynLib detectRUNS
#' @importFrom Rcpp sourceCpp
#'
homoZygotTestCpp <- function(x, gaps, maxHet, maxMiss, maxGap) {
    .Call('_detectRUNS_homoZygotTestCpp', PACKAGE = 'detectRUNS', x, gaps, maxHet, maxMiss, maxGap)
}

#' Function to check whether a window is (loosely) heterozygous or not
#'
#' This is a core function. Parameters on how to consider a window heterozygous are here (maxHom, maxMiss)
#'
#' @param x vector of 0/1 genotypes (from genoConvert())
#' @param gaps vector of differences between consecutive positions (gaps) in bps
#' @param maxHom max n. of homozygous SNP in a heterozygous window
#' @param maxMiss max n. of missing in a window
#' @param maxGap max distance between consecutive SNP in a window to be still considered a potential run
#'
#' @return TRUE/FALSE (whether a window is heterozygous or NOT)
#'
#' @useDynLib detectRUNS
#' @importFrom Rcpp sourceCpp
#'
heteroZygotTestCpp <- function(x, gaps, maxHom, maxMiss, maxGap) {
    .Call('_detectRUNS_heteroZygotTestCpp', PACKAGE = 'detectRUNS', x, gaps, maxHom, maxMiss, maxGap)
}

#' Function to calculate oppositeAndMissingGenotypes array
#'
#' This is an helper function, this will be called by another function
#'
#' @param data vector of 0/1/2 genotypes
#' @param ROHet TRUE in ROHet evaluation, FALSE for ROHom
#'
#' @return character array; names will be index in which opposite and missing
#' snps are found in data array
#'
#' @useDynLib detectRUNS
#' @importFrom Rcpp sourceCpp
#'
findOppositeAndMissing <- function(data, ROHet = TRUE) {
    .Call('_detectRUNS_findOppositeAndMissing', PACKAGE = 'detectRUNS', data, ROHet)
}

#' Function to slide a window over a vector (individual's genotypes)
#'
#' This is a core function. The functions to detect RUNS are slid over the genome
#'
#' @param data vector of 0/1/2 genotypes
#' @param gaps vector of differences between consecutive positions (gaps) in bps
#' @param windowSize size of window (n. of SNP)
#' @param step by which (how many SNP) is the window slid
#' @param maxGap max distance between consecutive SNP in a window to be still considered a potential run
#' @param ROHet shall we detect ROHet or ROHom?
#' @param maxOppositeGenotype max n. of homozygous/heterozygous SNP
#' @param maxMiss max. n. of missing SNP
#'
#' @return vector of TRUE/FALSE (whether a window is homozygous or NOT)
#'
#' @useDynLib detectRUNS
#' @importFrom Rcpp sourceCpp
#'
slidingWindowCpp <- function(data, gaps, windowSize, step, maxGap, ROHet = TRUE, maxOppositeGenotype = 1L, maxMiss = 1L) {
    .Call('_detectRUNS_slidingWindowCpp', PACKAGE = 'detectRUNS', data, gaps, windowSize, step, maxGap, ROHet, maxOppositeGenotype, maxMiss)
}

#' Function to return a vector of T/F for whether a SNP is or not in a RUN
#'
#' This is a core function. The function to determine whether a SNP is or not in a RUN.
#' The ratio between homozygous/heterozygous windows and total n. of windows is computed here
#'
#' @param RunVector vector of TRUE/FALSE (is a window homozygous/heterozygous?)
#' @param windowSize size of window (n. of SNP)
#' @param threshold threshold to call a SNP in a RUN
#'
#' @return vector of TRUE/FALSE (whether a SNP is in a RUN or NOT)
#'
#' @useDynLib detectRUNS
#' @importFrom Rcpp sourceCpp
#'
snpInRunCpp <- function(RunVector, windowSize, threshold) {
    .Call('_detectRUNS_snpInRunCpp', PACKAGE = 'detectRUNS', RunVector, windowSize, threshold)
}

#' Function to return a dataframe of population (POP, ID)
#'
#' This is a core function. Read PED file and returns a data.frame with the first two
#' columns
#'
#' @param genotypeFile genotype (.ped) file location
#'
#' @return a dataframe of POP, ID
#'
#' @useDynLib detectRUNS
#' @importFrom Rcpp sourceCpp
#'
readPOPCpp <- function(genotypeFile) {
    .Call('_detectRUNS_readPOPCpp', PACKAGE = 'detectRUNS', genotypeFile)
}

#' Function to detect consecutive runs in a vector (individual's genotypes)
#'
#' This is a core function. It implements the consecutive method for detection of runs in diploid genomes
#' (see Marras et al. 2015)
#'
#' @param indGeno vector of 0/1/NAs of individual genotypes (0: homozygote; 1: heterozygote)
#' @param individual list of group (breed, population, case/control etc.) and ID of individual sample
#' @param mapFile Plink map file (for SNP position)
#' @param ROHet shall we detect ROHet or ROHom?
#' @param minSNP minimum number of SNP in a run
#' @param maxOppositeGenotype max n. of homozygous/heterozygous SNP
#' @param maxMiss max. n. of missing SNP
#' @param minLengthBps min length of a run in bps
#' @param maxGap max distance between consecutive SNP in a window to be still considered a potential run
#'
#' @details
#' The consecutive method detect runs by consecutively scanning SNP loci along the genome.
#' No sliding windows are used. Checks on minimum n. of SNP, max n. of opposite and missing genotypes,
#' max gap between adjacent loci and minimum length of the run are implemented (as in the sliding window method).
#' Both runs of homozygosity (RoHom) and of heterozygosity (RoHet) can be search for (option ROHet: TRUE/FALSE)
#'
#' @return A data frame of runs per individual sample
#'
#' @useDynLib detectRUNS
#' @importFrom Rcpp sourceCpp
#'
consecutiveRunsCpp <- function(indGeno, individual, mapFile, ROHet = TRUE, minSNP = 3L, maxOppositeGenotype = 1L, maxMiss = 1L, minLengthBps = 1000L, maxGap = 10e5L) {
    .Call('_detectRUNS_consecutiveRunsCpp', PACKAGE = 'detectRUNS', indGeno, individual, mapFile, ROHet, minSNP, maxOppositeGenotype, maxMiss, minLengthBps, maxGap)
}

#' Function to count number of times a SNP is in a RUN
#'
#'
#' @param runsChrom R object (dataframe) with results per chromosome
#' @param mapChrom R map object with SNP per chromosome
#' @param genotypeFile genotype (.ped) file location
#'
#' @return dataframe with counts per SNP in runs (per population)
#'
#' @import utils
#'
#' @useDynLib detectRUNS
#' @importFrom Rcpp sourceCpp
#'
snpInsideRunsCpp <- function(runsChrom, mapChrom, genotypeFile) {
    .Call('_detectRUNS_snpInsideRunsCpp', PACKAGE = 'detectRUNS', runsChrom, mapChrom, genotypeFile)
}

