% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getLSAF.R
\name{getLSAF}
\alias{getLSAF}
\title{Low Spectral Anomaly Frequency (LSAF)}
\usage{
getLSAF(resid, years, for.year = NULL)
}
\arguments{
\item{resid}{A vector of residual values generated with respect to the baseline signal}

\item{years}{A vector of years corrosponding to the residual values}

\item{for.year}{(optional) Calculate LSAF values only for the given year in this argument.
If argument is omitted, LSAF values for all years are calculated.}
}
\value{
Data frame containing two Columns:
\tabular{ll}{
\code{year} \tab First column, represents year \cr
\code{LSAF} \tab Second column, represents LSAF values
}
}
\description{
Compute Low Spectral Anomaly Frequency (LSAF) from the given residual values.
}
\examples{
# load sample data
data("sycamore")
x = sycamore

# get streamflow object for the sample data
x.streamflow = asStreamflow(x)

# prepare baseline signal 
x.bl = prepareBaseline(x.streamflow)

# LSAF
lsaf = getLSAF(x.bl$resid.sig, x.streamflow$data$year)

}
