% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getFPExt.R
\name{getFPExt}
\alias{getFPExt}
\title{Flood Pulse Extent (FPExt)}
\usage{
getFPExt(resid, years, for.year = NULL)
}
\arguments{
\item{resid}{A vector of residual values generated with respect to the baseline signal}

\item{years}{A vector of years corrosponding to the residual values}

\item{for.year}{(optional) Calculate FPExt values only for the given year in this argument.
If argument is omitted, NAA values for all years are calculated.}
}
\value{
Data frame containing two columns: 
\tabular{ll}{
\code{year} \tab First column, represents year \cr
\code{FPExt} \tab Second column, represents FPExt values
}
}
\description{
Calculate the Flood Pulse Extent (FPExt) from the given residual values.
}
\examples{
# load sample data
data("sycamore")
x = sycamore

# get streamflow object for the sample data
x.streamflow = asStreamflow(x)

# prepare baseline signal 
x.bl = prepareBaseline(x.streamflow)

# FPExt
fpext = getFPExt(x.bl$resid.sig, x.streamflow$data$year)

}
