% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discovr_data.R
\docType{data}
\name{zhang_sample}
\alias{zhang_sample}
\title{Zhang et al. (2013) (subsample)}
\format{
A tibble with 52 rows and 4 variables
}
\source{
\href{https://www.discovr.rocks/csv/zhang_2013_subsample.csv}{www.discovr.rocks/csv/zhang_2013_subsample.csv}
}
\usage{
zhang_sample
}
\description{
A dataset from Field, A. P. (2026). Discovering statistics using R and RStudio (2nd ed.). London: Sage.
}
\details{
Statistics and maths anxiety are common and affect people's performance on maths and stats assignments; women in particular can lack confidence in mathematics (Field, 2010).
Zhang, Schmader and Hall (2013) did an intriguing study in which students completed a maths test in which some put their own name on the test booklet,
whereas others were given a booklet that already had either a male or female name on. Participants in the latter two conditions were told that they would use this other person's name for the purpose of the test.
Women who completed the test using a different name performed significantly better than those who completed the test using their own name. (There were no such significant effects for men.)
The data are a random subsample of Zhang et al.'s data with the following variables:
\itemize{
\item \strong{id}: participant ID
\item \strong{sex}: participant's biological sex
\item \strong{name_type}: the booklet condition to which the participant was allocated: Female fake name, Male fake name or Own name
\item \strong{accuracy}: the participant's score on the maths test
}
}
\references{
\itemize{
\item Field, A. P. (2010). Teaching Statistics. In D. Upton & A. Trapp (Eds.), \emph{Teaching Psychology in Higher Education} (pp. 134-163). Chichester, UK: Wiley-Blackwell.
\item Zhang, S., Schmader, T., & Hall, W. M. (2013). L'eggo My Ego: Reducing the Gender Gap in Math by Unlinking the Self from Performance. \emph{Self and Identity}, \emph{12}, 400-412. \doi{10.1080/15298868.2012.687012}
}
}
\keyword{datasets}
