% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/div_gauge_plot.R
\name{div_gauge_plot}
\alias{div_gauge_plot}
\title{Uses ggplot2 to produce a gauge plot in RAG colour}
\usage{
div_gauge_plot(df, breaks = c(0, 0.8, 0.95, 1), ncol = NULL, nbrSize = 6)
}
\arguments{
\item{df}{tibble, a tibble with columns "value" and "label" (value = the values between 0 and 1;  - label = text to show e.g. paste("group", colnames(t)))}

\item{breaks}{numeric vector with the lower limit, the border between green and amber, the border between amber and red, and the upper limit}

\item{ncol}{numeric, the number of columns to produce}

\item{nbrSize}{numeric, the font size for the label}
}
\value{
ggplot object
}
\description{
This function produces one or more gauge plots coloured in red (R), amber (A) or green (G) for a value between 0 and 1.
}
\examples{
d <- div_fake_team()
tbl_gender_div <- table(d$gender, d$grade) \%>\%
   apply(2, diversity, prior = c(50.2, 49.8)) \%>\%
   tibble(value = ., label = paste("Grade", names(.)))
div_gauge_plot(tbl_gender_div, ncol = 2, nbrSize = 4)
}
\keyword{gauge}
\keyword{plot}
