% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/div_paygap.R
\name{div_paygap}
\alias{div_paygap}
\title{Function to calculate the paygap as a ratio.}
\usage{
div_paygap(d, x = "gender", y = "salary", x_ctrl = "F", ctrl_var = "age")
}
\arguments{
\item{d}{tibble, a tibble with columns as definded}

\item{x}{the name of the columns that contains the factor object to be used as explaining dimension for the paygap (defaults to 'gender')}

\item{y}{the name of the columns that contains the numeric value to be used to calculate the paygap  (could be salary or bonus for example)}

\item{x_ctrl}{the value in the column defined by x that should be isolated (this versus the others), defaults to 'F'}

\item{ctrl_var}{a control variable to be added (shows median per group for that variable)}
}
\value{
dataframe (with columns grade, jobID, salary_x_ctrl, salary_others, n_x_ctrl, n_others, paygap, confidence) , where "confidence" is one of the following: NA = not available (numbers are too low), "" = no bias detectable, "." = there might be some bias, but we're not sure, "*" = bias detected wit some degree of confidence, "**" = quite sure there is bias, "***" = trust us, this is biased.
}
\description{
This function calculates the entropy of a system with discrete states
}
\examples{
df <- div_paygap(div_fake_team())
df
}
\keyword{(seniority)}
\keyword{(type}
\keyword{-}
\keyword{a}
\keyword{and}
\keyword{by}
\keyword{calculate}
\keyword{controlled}
\keyword{d}
\keyword{dataset}
\keyword{for}
\keyword{grade}
\keyword{jobID}
\keyword{of}
\keyword{paygap}
\keyword{role)}
\keyword{the}
