% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2Dplots.R
\name{plot_gmm_2D_orig}
\alias{plot_gmm_2D_orig}
\title{Plot  of GMM decomposition for 2D data}
\usage{
plot_gmm_2D_orig(X, gmm, opts)
}
\arguments{
\item{X}{Matrix of 2D data to decompose by GMM.}

\item{gmm}{Results of \code{\link{gaussian_mixture_2D}} decomposition}

\item{opts}{Parameters of run stored in \code{\link{GMM_2D_opts}} variable.}
}
\value{
A \code{ggplot} object showing the scatter plot of two-dimensional
data with an overlay of the Gaussian mixture model decomposition. Mixture
component centers are indicated by points and covariance ellipses corresponding
to selected probability contours are drawn around each component.
}
\description{
Function plot the decomposed distribution together with histogram of data.
This plot is also return as regular output of \code{\link{runGMM}}.
}
\examples{
\donttest{
custom.settings <- GMM_2D_opts
data <- generate_norm2D(1500, alpha = c(0.2, 0.4, 0.4),
                              mu = matrix(c(1, 2, 1, 3, 2, 2), nrow = 2),
                              cov = c(0.01, 0.02, 0.03))

res <- runGMM2D(data$Dist, opts = custom.settings)
plot_gmm_2D_orig(data$Dist, res$model, custom.settings)
}
}
\seealso{
\code{\link{runGMM2D}}
}
