% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ds.bind_cols.R
\name{ds.bind_cols}
\alias{ds.bind_cols}
\title{Bind multiple data frames by column}
\usage{
ds.bind_cols(
  to_combine = NULL,
  .name_repair = c("unique", "universal", "check_unique", "minimal"),
  newobj = NULL,
  datasources = NULL
)
}
\arguments{
\item{to_combine}{Data frames to combine. Each argument can either be a data frame, a list that
could be a data frame, or a list of data frames. Columns are matched by name, and any missing
columns will be filled with NA.}

\item{.name_repair}{One of "unique", "universal", or "check_unique". See
\code{vctrs::vec_as_names()} for the meaning of these options.}

\item{newobj}{Character specifying name for new server-side data frame.}

\item{datasources}{datashield connections object.}
}
\value{
No return value, called for its side effects. A data frame with the name specified by
\code{newobj} and the same type as the first element of \code{to_combine} is created on the
server.
}
\description{
DataSHIELD implementation of \code{dplyr::bind_cols}.
}
\examples{
\dontrun{
## First log in to a DataSHIELD session with mtcars dataset loaded.

ds.bind_cols(
  to_combine = list(mtcars, mtcars),
  .name_repair = "universal",
  newobj = "test",
  datasources = conns
)

## Refer to the package vignette for more examples.
}
}
