% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliaries.r
\name{igammac}
\alias{igammac}
\title{Complementary Incomplete Gamma Function}
\usage{
igammac(a, x)
}
\arguments{
\item{a}{A numeric vector.}

\item{x}{A nonnegative numeric vector with same length as \code{a}.}
}
\value{
A vector of values of a complementary incomplete gamma function.
}
\description{
Evaluate an complementary incomplete gamma function:
\deqn{\gamma^{*}(a, x) = \int_{x}^{\infty} t^{a-1} e^{-t}dt,}
using SLATEC \code{dgamic} in \url{https://netlib.org/slatec/}.
When (\eqn{x > 0} and \eqn{a \ge 0}) or (\eqn{x \ge 0} and \eqn{a > 0}),
compute the result, otherwise the value is \code{NaN}.
}
\examples{
igammac(1, 1)
}
\seealso{
\code{\link[=igamma]{igamma()}}
}
