% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step-group.R
\name{group_by.dtplyr_step}
\alias{group_by.dtplyr_step}
\alias{ungroup.dtplyr_step}
\title{Group and ungroup}
\usage{
\method{group_by}{dtplyr_step}(.data, ..., .add = FALSE, arrange = TRUE)

\method{ungroup}{dtplyr_step}(x, ...)
}
\arguments{
\item{.data}{A \code{\link[=lazy_dt]{lazy_dt()}}}

\item{...}{In \code{group_by()}, variables or computations to group by.
Computations are always done on the ungrouped data frame.
To perform computations on the grouped data, you need to use
a separate \code{mutate()} step before the \code{group_by()}.
Computations are not allowed in \code{nest_by()}.
In \code{ungroup()}, variables to remove from the grouping.}

\item{.add, add}{When \code{FALSE}, the default, \code{group_by()} will
override existing groups. To add to the existing groups, use
\code{.add = TRUE}.

This argument was previously called \code{add}, but that prevented
creating a new grouping variable called \code{add}, and conflicts with
our naming conventions.}

\item{arrange}{If \code{TRUE}, will automatically arrange the output of
subsequent grouped operations by group. If \code{FALSE}, output order will be
left unchanged. In the generated data.table code this switches between
using the \code{keyby} (\code{TRUE}) and \code{by} (\code{FALSE}) arguments.}

\item{x}{A \code{\link[dplyr:tbl]{tbl()}}}
}
\description{
These are methods for dplyr's \code{\link[dplyr:group_by]{dplyr::group_by()}} and \code{\link[dplyr:group_by]{dplyr::ungroup()}} generics.
Grouping is translated to the either \code{keyby} and \code{by} argument of
\verb{[.data.table} depending on the value of the \code{arrange} argument.
}
\examples{
library(dplyr, warn.conflicts = FALSE)
dt <- lazy_dt(mtcars)

# group_by() is usually translated to `keyby` so that the groups
# are ordered in the output
dt \%>\%
 group_by(cyl) \%>\%
 summarise(mpg = mean(mpg))

# use `arrange = FALSE` to instead use `by` so the original order
# or groups is preserved
dt \%>\%
 group_by(cyl, arrange = FALSE) \%>\%
 summarise(mpg = mean(mpg))
}
