% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDiffGrid.R
\name{plotDiffGrid}
\alias{plotDiffGrid}
\title{Plot Diffusion Grids}
\usage{
plotDiffGrid(filename, species = c(TRUE, TRUE, FALSE), scale.factor = 1)
}
\arguments{
\item{filename}{Name of the file that contains the results of a cyclic voltammetry, linear sweep voltammetry, chronoamperometry, or chronocoulometry simulation created using \code{cvSim}, \code{lsvSim}, \code{caSim}, or \code{ccSim}.}

\item{species}{A vector of three logical values (\code{T} or \code{F}) indicating the species for which diffusion grids are displayed. The order in which species are identified is Ox, Red, and Z.}

\item{scale.factor}{A factor for adjusting the scale on the \emph{x}-axis. Setting the scale.factor to a value of less than 1 decreases the range of distances displayed in the diffusion grids.}
}
\value{
Returns a single plot showing 1--3 diffusion grids.
}
\description{
Plots the diffusion grids used in cyclic voltammetry, linear sweep voltammetry, chronoamperometry, and chronocoulometry simulation. The diffusion grids are presented as heat maps giving the concentration of Ox, Red, or Z as a function of distance from the electrode surface on the \emph{x}-axis and time on the \emph{y}- axis. The scale on the \emph{x}-axis may be adjusted to highlight better the diffusion grid near the electrode's surface. Note: the \code{plotDiffGrid} function requires that the \code{plot3D} package is installed.
}
\examples{
ex_cv = simulateCV(e.start = 0.25, e.switch = -0.25, e.form = 0,
  x.units = 100, t.units = 1000)
plotDiffGrid(ex_cv, species = c(TRUE, TRUE, FALSE),
  scale.factor = 0.5)
}
