% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iter_helpers.R
\name{helpers}
\alias{helpers}
\alias{items}
\alias{vals}
\alias{enum}
\alias{rows}
\alias{cols}
\alias{zip}
\alias{lrep}
\alias{transpose}
\alias{slice}
\alias{roll}
\alias{unroll}
\alias{lagg}
\alias{groups}
\alias{chars}
\alias{chain}
\alias{separate}
\alias{first}
\alias{rest}
\alias{splitn}
\title{Helpers for Vector Comprehension}
\usage{
items(x)

vals(x)

enum(x)

rows(x, ...)

cols(x, ...)

zip(..., fill = NA, longest = TRUE)

lrep(x, n = 2, axis = 0)

transpose(x, fill = NA, longest = TRUE)

slice(x, start, end, by = 1L)

roll(x, n = 2, fill = NULL, head = TRUE, ...)

unroll(x)

lagg(x, k = 1, fill = NA, axis = 0)

groups(x, g)

chars(x)

chain(x)

separate(x, n = 2, fill = NA)

first(x)

rest(x)

splitn(x, n = 1)
}
\arguments{
\item{x}{list, environment, or other vector}

\item{...}{vectors to combine}

\item{fill}{object with which to fill the vector when operating on elements with varying lengths or shifts.}

\item{longest}{logical; should the longest item be used to determine the new length or shortest? Defaults to \code{TRUE}.}

\item{n}{size of window for \code{roll} and \code{separate}, or position of item in which to split each element in \code{splitn}}

\item{axis}{which axis to perform different operations? \code{axis=0}, the default, performs operations on each element in the list (columns), while \code{axis=1} performs operations on each object within the elements of a list (rows).}

\item{start, end, by}{integers of length 1 describing the sequence for slicing the vector. If missing, they will default to the start or end of the vector.}

\item{head}{logical; should \code{fill} be at the head of the vector or the tail?}

\item{k}{number of elements to shift right. Negative values of \code{k} shift to the left}

\item{g}{vector of objects used to define groups}
}
\value{
list or other vector
}
\description{
These functions help to create sequences for use in vector \link{comprehension}.
}
\details{
These functions transform vectors or other objects into lists, by adding elements,
grouping objects, extracting certain elements, and so forth. These can be used
in conjunction with vector \code{\link{comprehension}} to develop quick and
readable code.

An example of how each of these can be used is seen here. Let \code{x} and \code{y}
be given as follows.

\code{x = list(a = 2, b = 4, c = 8)}
\code{y = list(1:2, 2:3, 3:4)}

Then the various helper functions will have the following effect.

\itemize{
\item \code{chain(y) => [1, 2, 2, 3, 3, 4]}
\item \code{chars("hello") => ['h', 'e', 'l', 'l', 'o']}
\item \code{enum(x) => [[1, 2], [2, 4], [3, 8]]}
\item \code{first(y) => [1, 2, 3]}
\item \code{groups(x, c("z", "w", "z")) => [["z", [2, 8]], ["w", [4]]]}
\item \code{items(x) => [["a", 2], ["b", 4], ["c", 8]]}
\item \code{lagg(x, 2) => [[2, 4, 8], [NA, 2, 4], [NA, NA, 2]]}
\item \code{lrep(x, 3) => [[2, 4, 8], [2, 4, 8], [2, 4, 8]]}
\item \code{rest(y) => [[2], [3], [4]]}
\item \code{roll(x, 2) => [[2, 4] [4, 8]]}
\item \code{separate(x, 2) => [[2, 4], [8, NA]]}
\item \code{slice(x,1,,2) => [2, 8]}
\item \code{splitn(y) => [[[1], [2]], [[2], [3]], [[3], [4]]]}
\item \code{transpose(y) => [[1, 2, 3], [2, 3, 4]]}
\item \code{unroll(y) => [1, 2, 3, 4]}
\item \code{vals(x) => [2, 4, 8]}
\item \code{zip(x, 1:3) => [[2, 1], [4, 2], [8, 3]]}
}
}
\section{Functions}{
\itemize{
\item \code{items}: Create a list containing the name of each element of \code{x} and its value.

\item \code{vals}: Extract the values of x without their names.

\item \code{enum}: Create a list containing the index of each element of \code{x} and its value.

\item \code{rows}: Create a list containing the rows of a data.frame or matrix

\item \code{cols}: Create a list containing the columns of a data.frame or matrix

\item \code{zip}: Merge two or more vectors into a list with each index containing values from each vector at that index.

\item \code{lrep}: Repeat \code{x}, \code{n} times, with each repetition being an item in a list.

\item \code{transpose}: Transpose a list or other object into a list. Opposite of \code{zip}.

\item \code{slice}: Subset an object by a sequence: \code{start}, \code{end}, \code{by}. If \code{start} is missing, it is assumed to be 1. If \code{end} is missing, it is assumed to be the length of the object.

\item \code{roll}: Create a list of objects containing \code{n} items from \code{x}, with \code{n-1} elements overlapping in a chain. Opposite of \code{unroll}.

\item \code{unroll}: Flatten a list by combining the unique elements between each group of two elements. Opposite of \code{roll}.

\item \code{lagg}: Create a list containing an object and each the first \code{k} lags of an object.

\item \code{groups}: Create a list where each element is a list with the first element equal to a unique value in \code{g} and the other element is a list containing all values of \code{x} at the same indices as the value of \code{g}.

\item \code{chars}: Convert a character string into a vector of single character values.

\item \code{chain}: Combine each object in a list. Opposite of \code{separate}.

\item \code{separate}: Separate vector into a list of objects with length \code{n}. Opposite of \code{chain}.

\item \code{first}: Take the first element of each item in a list.

\item \code{rest}: Remove the first element of each item in a list.

\item \code{splitn}: Split each element in a list into two parts: one with the first \code{n} elements and the second with the rest.
}}

\examples{
x <- 1:10
y <- 32:35

n <- Num(for (i.j in zip(x,y)) i+j)
# Note that the result is different from x+y since the shortest does not repeat
mean(n[1:4])

e <- new.env()
e$a <- 1:5
e$b <- 6:10

e2 <- Env(for (key.val in items(e)) key = sqrt(val))
e2$a

# row product
mat <- matrix(1:9, nrow=3)
Num(for (i in rows(mat)) prod(i))
}
