% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sc.R
\name{get_marker}
\alias{get_marker}
\title{Retrieve Markers for Specific Cells from cellMarker2}
\usage{
get_marker(
  spc,
  cell = character(),
  tissueClass = available_tissue_class(spc),
  tissueType = available_tissue_type(spc),
  number = 5,
  min.count = 1
)
}
\arguments{
\item{spc}{A character string specifying the species, which can be either
'Human' or 'Mouse'.}

\item{cell}{A character vector of cell types for which to retrieve markers.}

\item{tissueClass}{A character specifying the tissue classes, default \code{available_tissue_class(spc)}.}

\item{tissueType}{A character specifying the tissue types, default \code{available_tissue_type(spc)}.}

\item{number}{An integer specifying the number of top markers to return for
each cell type.}

\item{min.count}{An integer representing the minimum number of times a marker
must have been reported to be included in the results.}
}
\value{
A named list where each name corresponds to a cell type and each
element is a vector of marker names.
}
\description{
This function extracts a list of markers for one or more cell types from the
\code{cellMarker2} dataset. It allows filtering by species, cell type, the number
of markers to retrieve, and a minimum count threshold for marker occurrences.
}
\examples{
# Example usage:
# Retrieve the top 5 markers for 'Macrophage' and 'Monocyte' cell types in humans,
# with a minimum count of 1.
library(easybio)
markers <- get_marker(spc = "Human", cell = c("Macrophage", "Monocyte"))
print(markers)
# Example with a typo in cell name
markers_typo <- get_marker(spc = "Human", cell = c("Macrophae", "Monocyte"))
}
